import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_artist_libraries';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('library_id').primary().notNullable();
            table
                .uuid('user_id')
                .notNullable()
                .unsigned()
                .references('user_id')
                .inTable('kloud_users')
                .onDelete('CASCADE');
            table
                .uuid('artist_id')
                .notNullable()
                .unsigned()
                .references('artist_id')
                .inTable('kloud_artists')
                .onDelete('CASCADE');
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707397748138_create_kloud_artist_libraries_table.js.map