import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_app_settings';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('app_setting_id').primary().notNullable();
            table.integer('setting_key').notNullable();
            table.string('name').notNullable();
            table.string('description').notNullable();
            table.string('slug').notNullable();
            table.string('setting_type').notNullable();
            table.jsonb('default_value').defaultTo({
                value: '',
            });
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1706988085007_create_kloud_app_settings_table.js.map