import env from '#start/env';
import { defineConfig, transports } from '@adonisjs/mail';
const mailConfig = defineConfig({
    default: 'smtp',
    mailers: {
        smtp: transports.smtp({
            host: env.get('SMTP_HOST'),
            port: env.get('SMTP_PORT'),
        }),
        ses: transports.ses({
            apiVersion: '2010-12-01',
            region: process.env.AWS_REGION,
            credentials: {
                accessKeyId: env.get('AWS_ACCESS_KEY_ID'),
                secretAccessKey: env.get('AWS_SECRET_ACCESS_KEY'),
            },
            sendingRate: 10,
            maxConnections: 5,
        }),
        resend: transports.resend({
            key: env.get('RESEND_API_KEY'),
            baseUrl: 'https://api.resend.com',
        }),
    },
});
export default mailConfig;
//# sourceMappingURL=mail.js.map