var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import SubscriptionPlans from '#models/subscription_plan';
import ApiResponseService from '#services/api_response_service';
import { createSubscriptionPlanValidator } from '#validators/operator_validator';
import string from '@adonisjs/core/helpers/string';
import { inject } from '@adonisjs/core';
let SubscriptionsController = class SubscriptionsController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async fetchAllSubscriptionPlan() {
        try {
            const subscriptionPlanList = await SubscriptionPlans.query().orderBy('id', 'asc');
            return this.apiResponseService.apiSuccessResponse(subscriptionPlanList);
        }
        catch (error) {
            logError(error.message, 'KloudaaOperator/SubscriptionsController/fetchAllSubscriptionPlan');
            return this.apiResponseService.apiErrorResponse(500, error.message ?? 'Server Error');
        }
    }
    async addNewSubscriptionPlan({ request }) {
        try {
            const payload = await createSubscriptionPlanValidator.validate(request.all());
            const doSubscriptionPlanExist = await SubscriptionPlans.query()
                .where('plan_slug', string.slug(payload.title, { lower: true }))
                .first();
            if (doSubscriptionPlanExist) {
                return this.apiResponseService.apiErrorResponse(403, 'Subscription plan already exists');
            }
            const subscriptionPlan = new SubscriptionPlans();
            subscriptionPlan.plan_title = payload.title;
            subscriptionPlan.plan_price = payload.price;
            subscriptionPlan.plan_duration = payload.duration;
            subscriptionPlan.plan_category = payload.category;
            subscriptionPlan.plan_slug = string.slug(payload.title, { lower: true });
            subscriptionPlan.plan_extra = payload.extra ?? {};
            subscriptionPlan.glassfy_detail = JSON.stringify(payload.glassfy_detail ?? {});
            subscriptionPlan.auto_renewal = true;
            await subscriptionPlan.save();
            return this.apiResponseService.apiSuccessResponse('', 'Subscription plan created successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaOperator/SubscriptionsController/addNewSubscriptionPlan');
            return this.apiResponseService.apiErrorResponse(500, error.message ?? 'Server Error');
        }
    }
};
SubscriptionsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], SubscriptionsController);
export default SubscriptionsController;
//# sourceMappingURL=subscriptions_controller.js.map