import router from '@adonisjs/core/services/router';
router
    .group(() => {
    router.get('homepage', '#controllers/KloudaaClient/homepages_controller.getHomePageContent');
    router.post('search/:searchKeyword', '#controllers/KloudaaClient/searches_controller.getSearchResults');
    router.get('genre', '#controllers/KloudaaClient/genres_controller.getGenresList');
    router.get('genre/:genreId', '#controllers/KloudaaClient/genres_controller.getGenresListByGenreId');
    router.get('chart', '#controllers/KloudaaClient/charts_controller.getChartList');
    router.get('album/:albumId', '#controllers/KloudaaClient/yt_media_details_controller.getAlbumDetailsByAlbumId');
    router.get('video/:videoId', '#controllers/KloudaaClient/yt_media_details_controller.getVideoDetailsByVideoId');
    router.get('song/:videoId', '#controllers/KloudaaClient/yt_media_details_controller.getSongDetailsByVideoId');
    router.get('lyrics/:videoId', '#controllers/KloudaaClient/yt_media_details_controller.getSongVideoLyricsByVideoId');
    router.get('artist/:artistId', '#controllers/KloudaaClient/yt_media_details_controller.getArtistByArtistId');
    router.get('playlist/:playlistId', '#controllers/KloudaaClient/yt_media_details_controller.getPlayListByPlayListId');
    router.get('playlist-video/:playlistId', '#controllers/KloudaaClient/yt_media_details_controller.getPlayListVideoByPlayListId');
    router.get('play/:videoId', '#controllers/KloudaaClient/stream_media_contents_controller.streamAudioFileWithYTVideoId');
    router.get('play-video/:videoId', '#controllers/KloudaaClient/stream_media_contents_controller.streamVideoFileWithYTVideoId');
})
    .prefix('v1/kloud-api');
//# sourceMappingURL=youtube_queries.js.map