import { middleware } from '#start/kernel';
import router from '@adonisjs/core/services/router';
router
    .group(() => {
    router.get('album-library', '#controllers/KloudaaClient/user_album_libraries_controller.fetchAlbumsLibrary');
    router.post('add-album-library', '#controllers/KloudaaClient/user_album_libraries_controller.addAlbumToLibrary');
    router.delete('album-library/:albumId', '#controllers/KloudaaClient/user_album_libraries_controller.removeAlbumFromLibrary');
    router.get('fetch-playlist', '#controllers/KloudaaClient/user_playlist_libraries_controller.fetchPlaylistLibrary');
    router.post('create-playlist', '#controllers/KloudaaClient/user_playlist_libraries_controller.createNewPlaylist');
    router.put('update-playlist', '#controllers/KloudaaClient/user_playlist_libraries_controller.updatePlaylist');
    router.delete('delete-playlist/:playlistId', '#controllers/KloudaaClient/user_playlist_libraries_controller.deletePlaylist');
    router.get('fetch-playlist-item/:playlistId', '#controllers/KloudaaClient/user_playlist_libraries_controller.fetchPlaylistItemsByPlaylistId');
    router.post('add-playlist-song', '#controllers/KloudaaClient/user_playlist_libraries_controller.addSongToPlaylist');
    router.delete('remove-playlist-item/:playlistItemId', '#controllers/KloudaaClient/user_playlist_libraries_controller.removeSongFromPlaylist');
    router.get('followed-artists', '#controllers/KloudaaClient/user_follow_artists_controller.fetchFollowedArtist');
    router.post('follow-artist', '#controllers/KloudaaClient/user_follow_artists_controller.followArtist');
    router.delete('unfollow-artist/:artistId', '#controllers/KloudaaClient/user_follow_artists_controller.unfollowArtist');
    router.get('favourite-items/:itemType?', '#controllers/KloudaaClient/user_favourite_items_controller.fetchFavouriteItems');
    router.post('add-favourite-item', '#controllers/KloudaaClient/user_favourite_items_controller.addItemToFavouriteItems');
    router.delete('remove-favourite-item/:favouriteId', '#controllers/KloudaaClient/user_favourite_items_controller.removeFromFavouriteItems');
})
    .prefix('v1/kloud-api')
    .use(middleware.auth({
    guards: ['kloudaa_user'],
}));
//# sourceMappingURL=media_library.js.map