import Country from '#models/country';
import { BaseSeeder } from '@adonisjs/lucid/seeders';
export default class extends BaseSeeder {
    async run() {
        let countryC = [
            {
                name: 'Bangladesh',
                isoCode: 'BD',
                phoneCode: '880',
                flag: {
                    emoji: '🇧🇩',
                    unicode: 'U+1F1E7 U+1F1E9',
                },
                currency: {
                    symbol: 'Tk',
                    name: 'Bangladeshi Taka',
                    symbol_native: '৳',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BDT',
                    name_plural: 'Bangladeshi takas',
                },
            },
            {
                name: 'Belgium',
                isoCode: 'BE',
                phoneCode: '32',
                flag: {
                    emoji: '🇧🇪',
                    unicode: 'U+1F1E7 U+1F1EA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Burkina Faso',
                isoCode: 'BF',
                phoneCode: '226',
                flag: {
                    emoji: '🇧🇫',
                    unicode: 'U+1F1E7 U+1F1EB',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Bulgaria',
                isoCode: 'BG',
                phoneCode: '359',
                flag: {
                    emoji: '🇧🇬',
                    unicode: 'U+1F1E7 U+1F1EC',
                },
                currency: {
                    symbol: 'BGN',
                    name: 'Bulgarian Lev',
                    symbol_native: 'лв.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BGN',
                    name_plural: 'Bulgarian leva',
                },
            },
            {
                name: 'Bosnia and Herzegovina',
                isoCode: 'BA',
                phoneCode: '387',
                flag: {
                    emoji: '🇧🇦',
                    unicode: 'U+1F1E7 U+1F1E6',
                },
                currency: {
                    symbol: 'KM',
                    name: 'Bosnia-Herzegovina Convertible Mark',
                    symbol_native: 'KM',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BAM',
                    name_plural: 'Bosnia-Herzegovina convertible marks',
                },
            },
            {
                name: 'Barbados',
                isoCode: 'BB',
                phoneCode: '+1-246',
                flag: {
                    emoji: '🇧🇧',
                    unicode: 'U+1F1E7 U+1F1E7',
                },
                currency: {
                    symbol: '$',
                    name: 'Barbados Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BBD',
                    name_plural: 'Barbados Dollar',
                },
            },
            {
                name: 'Wallis and Futuna',
                isoCode: 'WF',
                phoneCode: '681',
                flag: {
                    emoji: '🇼🇫',
                    unicode: 'U+1F1FC U+1F1EB',
                },
                currency: {
                    symbol: '₣',
                    name: 'CFP Franc',
                    symbol_native: '₣',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XPF',
                    name_plural: 'CFP Franc',
                },
            },
            {
                name: 'Saint Barthelemy',
                isoCode: 'BL',
                phoneCode: '590',
                flag: {
                    emoji: '🇧🇱',
                    unicode: 'U+1F1E7 U+1F1F1',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Bermuda',
                isoCode: 'BM',
                phoneCode: '+1-441',
                flag: {
                    emoji: '🇧🇲',
                    unicode: 'U+1F1E7 U+1F1F2',
                },
                currency: {
                    symbol: '$',
                    name: 'Bermudian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BMD',
                    name_plural: 'Bermudian Dollar',
                },
            },
            {
                name: 'Brunei',
                isoCode: 'BN',
                phoneCode: '673',
                flag: {
                    emoji: '🇧🇳',
                    unicode: 'U+1F1E7 U+1F1F3',
                },
                currency: {
                    symbol: 'BN$',
                    name: 'Brunei Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BND',
                    name_plural: 'Brunei dollars',
                },
            },
            {
                name: 'Bolivia',
                isoCode: 'BO',
                phoneCode: '591',
                flag: {
                    emoji: '🇧🇴',
                    unicode: 'U+1F1E7 U+1F1F4',
                },
                currency: {
                    symbol: 'Bs',
                    name: 'Bolivian Boliviano',
                    symbol_native: 'Bs',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BOB',
                    name_plural: 'Bolivian bolivianos',
                },
            },
            {
                name: 'Bahrain',
                isoCode: 'BH',
                phoneCode: '973',
                flag: {
                    emoji: '🇧🇭',
                    unicode: 'U+1F1E7 U+1F1ED',
                },
                currency: {
                    symbol: 'BD',
                    name: 'Bahraini Dinar',
                    symbol_native: 'د.ب.‏',
                    decimal_digits: 3,
                    rounding: 0,
                    code: 'BHD',
                    name_plural: 'Bahraini dinars',
                },
            },
            {
                name: 'Burundi',
                isoCode: 'BI',
                phoneCode: '257',
                flag: {
                    emoji: '🇧🇮',
                    unicode: 'U+1F1E7 U+1F1EE',
                },
                currency: {
                    symbol: 'FBu',
                    name: 'Burundian Franc',
                    symbol_native: 'FBu',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'BIF',
                    name_plural: 'Burundian francs',
                },
            },
            {
                name: 'Benin',
                isoCode: 'BJ',
                phoneCode: '229',
                flag: {
                    emoji: '🇧🇯',
                    unicode: 'U+1F1E7 U+1F1EF',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Bhutan',
                isoCode: 'BT',
                phoneCode: '975',
                flag: {
                    emoji: '🇧🇹',
                    unicode: 'U+1F1E7 U+1F1F9',
                },
                currency: {
                    symbol: 'Nu.',
                    name: 'Bhutanese Ngultrum',
                    symbol_native: 'Nu.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BTN',
                    name_plural: 'Bhutanese Ngultrum',
                },
            },
            {
                name: 'Jamaica',
                isoCode: 'JM',
                phoneCode: '+1-876',
                flag: {
                    emoji: '🇯🇲',
                    unicode: 'U+1F1EF U+1F1F2',
                },
                currency: {
                    symbol: 'J$',
                    name: 'Jamaican Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'JMD',
                    name_plural: 'Jamaican dollars',
                },
            },
            {
                name: 'Bouvet Island',
                isoCode: 'BV',
                phoneCode: '0055',
                flag: {
                    emoji: '🇧🇻',
                    unicode: 'U+1F1E7 U+1F1FB',
                },
                currency: {
                    symbol: 'Nkr',
                    name: 'Norwegian Krone',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NOK',
                    name_plural: 'Norwegian kroner',
                },
            },
            {
                name: 'Botswana',
                isoCode: 'BW',
                phoneCode: '267',
                flag: {
                    emoji: '🇧🇼',
                    unicode: 'U+1F1E7 U+1F1FC',
                },
                currency: {
                    symbol: 'BWP',
                    name: 'Botswanan Pula',
                    symbol_native: 'P',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BWP',
                    name_plural: 'Botswanan pulas',
                },
            },
            {
                name: 'Samoa',
                isoCode: 'WS',
                phoneCode: '685',
                flag: {
                    emoji: '🇼🇸',
                    unicode: 'U+1F1FC U+1F1F8',
                },
                currency: {
                    symbol: 'WS$',
                    name: 'Samoan Tala',
                    symbol_native: 'WS$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'WST',
                    name_plural: 'Samoan Tala',
                },
            },
            {
                name: 'Bonaire, Saint Eustatius and Saba ',
                isoCode: 'BQ',
                phoneCode: '599',
                flag: {
                    emoji: '🇧🇶',
                    unicode: 'U+1F1E7 U+1F1F6',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Brazil',
                isoCode: 'BR',
                phoneCode: '55',
                flag: {
                    emoji: '🇧🇷',
                    unicode: 'U+1F1E7 U+1F1F7',
                },
                currency: {
                    symbol: 'R$',
                    name: 'Brazilian Real',
                    symbol_native: 'R$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BRL',
                    name_plural: 'Brazilian reals',
                },
            },
            {
                name: 'Bahamas',
                isoCode: 'BS',
                phoneCode: '+1-242',
                flag: {
                    emoji: '🇧🇸',
                    unicode: 'U+1F1E7 U+1F1F8',
                },
                currency: {
                    symbol: '$',
                    name: 'Bahamian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BSD',
                    name_plural: 'Bahamian Dollar',
                },
            },
            {
                name: 'Jersey',
                isoCode: 'JE',
                phoneCode: '+44-1534',
                flag: {
                    emoji: '🇯🇪',
                    unicode: 'U+1F1EF U+1F1EA',
                },
                currency: {
                    symbol: '£',
                    name: 'British Pound Sterling',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GBP',
                    name_plural: 'British pounds sterling',
                },
            },
            {
                name: 'Belarus',
                isoCode: 'BY',
                phoneCode: '375',
                flag: {
                    emoji: '🇧🇾',
                    unicode: 'U+1F1E7 U+1F1FE',
                },
                currency: {
                    symbol: 'Br',
                    name: 'Belarusian Ruble',
                    symbol_native: 'Br',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BYR',
                    name_plural: 'Belarusian Ruble',
                },
            },
            {
                name: 'Belize',
                isoCode: 'BZ',
                phoneCode: '501',
                flag: {
                    emoji: '🇧🇿',
                    unicode: 'U+1F1E7 U+1F1FF',
                },
                currency: {
                    symbol: 'BZ$',
                    name: 'Belize Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'BZD',
                    name_plural: 'Belize dollars',
                },
            },
            {
                name: 'Russia',
                isoCode: 'RU',
                phoneCode: '7',
                flag: {
                    emoji: '🇷🇺',
                    unicode: 'U+1F1F7 U+1F1FA',
                },
                currency: {
                    symbol: 'RUB',
                    name: 'Russian Ruble',
                    symbol_native: '₽.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'RUB',
                    name_plural: 'Russian rubles',
                },
            },
            {
                name: 'Rwanda',
                isoCode: 'RW',
                phoneCode: '250',
                flag: {
                    emoji: '🇷🇼',
                    unicode: 'U+1F1F7 U+1F1FC',
                },
                currency: {
                    symbol: 'RWF',
                    name: 'Rwandan Franc',
                    symbol_native: 'FR',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'RWF',
                    name_plural: 'Rwandan francs',
                },
            },
            {
                name: 'Serbia',
                isoCode: 'RS',
                phoneCode: '381',
                flag: {
                    emoji: '🇷🇸',
                    unicode: 'U+1F1F7 U+1F1F8',
                },
                currency: {
                    symbol: 'din.',
                    name: 'Serbian Dinar',
                    symbol_native: 'дин.',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'RSD',
                    name_plural: 'Serbian dinars',
                },
            },
            {
                name: 'East Timor',
                isoCode: 'TL',
                phoneCode: '670',
                flag: {
                    emoji: '🇹🇱',
                    unicode: 'U+1F1F9 U+1F1F1',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Reunion',
                isoCode: 'RE',
                phoneCode: '262',
                flag: {
                    emoji: '🇷🇪',
                    unicode: 'U+1F1F7 U+1F1EA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Turkmenistan',
                isoCode: 'TM',
                phoneCode: '993',
                flag: {
                    emoji: '🇹🇲',
                    unicode: 'U+1F1F9 U+1F1F2',
                },
                currency: {
                    symbol: 'm',
                    name: 'Manat',
                    symbol_native: 'm',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'TMT',
                    name_plural: 'Manat',
                },
            },
            {
                name: 'Tajikistan',
                isoCode: 'TJ',
                phoneCode: '992',
                flag: {
                    emoji: '🇹🇯',
                    unicode: 'U+1F1F9 U+1F1EF',
                },
                currency: {
                    symbol: 'ЅM',
                    name: 'Tajikistan Somoni',
                    symbol_native: 'ЅM',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'TJS',
                    name_plural: 'Tajikistan Somoni',
                },
            },
            {
                name: 'Romania',
                isoCode: 'RO',
                phoneCode: '40',
                flag: {
                    emoji: '🇷🇴',
                    unicode: 'U+1F1F7 U+1F1F4',
                },
                currency: {
                    symbol: 'RON',
                    name: 'Romanian Leu',
                    symbol_native: 'RON',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'RON',
                    name_plural: 'Romanian lei',
                },
            },
            {
                name: 'Tokelau',
                isoCode: 'TK',
                phoneCode: '690',
                flag: {
                    emoji: '🇹🇰',
                    unicode: 'U+1F1F9 U+1F1F0',
                },
                currency: {
                    symbol: 'NZ$',
                    name: 'New Zealand Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NZD',
                    name_plural: 'New Zealand dollars',
                },
            },
            {
                name: 'Guinea-Bissau',
                isoCode: 'GW',
                phoneCode: '245',
                flag: {
                    emoji: '🇬🇼',
                    unicode: 'U+1F1EC U+1F1FC',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Guam',
                isoCode: 'GU',
                phoneCode: '+1-671',
                flag: {
                    emoji: '🇬🇺',
                    unicode: 'U+1F1EC U+1F1FA',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Guatemala',
                isoCode: 'GT',
                phoneCode: '502',
                flag: {
                    emoji: '🇬🇹',
                    unicode: 'U+1F1EC U+1F1F9',
                },
                currency: {
                    symbol: 'GTQ',
                    name: 'Guatemalan Quetzal',
                    symbol_native: 'Q',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GTQ',
                    name_plural: 'Guatemalan quetzals',
                },
            },
            {
                name: 'South Georgia and the South Sandwich Islands',
                isoCode: 'GS',
                phoneCode: '500',
                flag: {
                    emoji: '🇬🇸',
                    unicode: 'U+1F1EC U+1F1F8',
                },
                currency: {
                    symbol: '£',
                    name: 'British Pound Sterling',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GBP',
                    name_plural: 'British pounds sterling',
                },
            },
            {
                name: 'Greece',
                isoCode: 'GR',
                phoneCode: '30',
                flag: {
                    emoji: '🇬🇷',
                    unicode: 'U+1F1EC U+1F1F7',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Equatorial Guinea',
                isoCode: 'GQ',
                phoneCode: '240',
                flag: {
                    emoji: '🇬🇶',
                    unicode: 'U+1F1EC U+1F1F6',
                },
                currency: {
                    symbol: 'FCFA',
                    name: 'CFA Franc BEAC',
                    symbol_native: 'FCFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XAF',
                    name_plural: 'CFA francs BEAC',
                },
            },
            {
                name: 'Guadeloupe',
                isoCode: 'GP',
                phoneCode: '590',
                flag: {
                    emoji: '🇬🇵',
                    unicode: 'U+1F1EC U+1F1F5',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Japan',
                isoCode: 'JP',
                phoneCode: '81',
                flag: {
                    emoji: '🇯🇵',
                    unicode: 'U+1F1EF U+1F1F5',
                },
                currency: {
                    symbol: '¥',
                    name: 'Japanese Yen',
                    symbol_native: '￥',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'JPY',
                    name_plural: 'Japanese yen',
                },
            },
            {
                name: 'Guyana',
                isoCode: 'GY',
                phoneCode: '592',
                flag: {
                    emoji: '🇬🇾',
                    unicode: 'U+1F1EC U+1F1FE',
                },
                currency: {
                    symbol: '$',
                    name: 'Guyanese Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GYD',
                    name_plural: 'Guyanese Dollar',
                },
            },
            {
                name: 'Guernsey',
                isoCode: 'GG',
                phoneCode: '+44-1481',
                flag: {
                    emoji: '🇬🇬',
                    unicode: 'U+1F1EC U+1F1EC',
                },
                currency: {
                    symbol: '£',
                    name: 'British Pound Sterling',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GBP',
                    name_plural: 'British pounds sterling',
                },
            },
            {
                name: 'French Guiana',
                isoCode: 'GF',
                phoneCode: '594',
                flag: {
                    emoji: '🇬🇫',
                    unicode: 'U+1F1EC U+1F1EB',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Georgia',
                isoCode: 'GE',
                phoneCode: '995',
                flag: {
                    emoji: '🇬🇪',
                    unicode: 'U+1F1EC U+1F1EA',
                },
                currency: {
                    symbol: 'GEL',
                    name: 'Georgian Lari',
                    symbol_native: 'GEL',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GEL',
                    name_plural: 'Georgian laris',
                },
            },
            {
                name: 'Grenada',
                isoCode: 'GD',
                phoneCode: '+1-473',
                flag: {
                    emoji: '🇬🇩',
                    unicode: 'U+1F1EC U+1F1E9',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'United Kingdom',
                isoCode: 'GB',
                phoneCode: '44',
                flag: {
                    emoji: '🇬🇧',
                    unicode: 'U+1F1EC U+1F1E7',
                },
                currency: {
                    symbol: '£',
                    name: 'British Pound Sterling',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GBP',
                    name_plural: 'British pounds sterling',
                },
            },
            {
                name: 'Gabon',
                isoCode: 'GA',
                phoneCode: '241',
                flag: {
                    emoji: '🇬🇦',
                    unicode: 'U+1F1EC U+1F1E6',
                },
                currency: {
                    symbol: 'FCFA',
                    name: 'CFA Franc BEAC',
                    symbol_native: 'FCFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XAF',
                    name_plural: 'CFA francs BEAC',
                },
            },
            {
                name: 'El Salvador',
                isoCode: 'SV',
                phoneCode: '503',
                flag: {
                    emoji: '🇸🇻',
                    unicode: 'U+1F1F8 U+1F1FB',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Guinea',
                isoCode: 'GN',
                phoneCode: '224',
                flag: {
                    emoji: '🇬🇳',
                    unicode: 'U+1F1EC U+1F1F3',
                },
                currency: {
                    symbol: 'FG',
                    name: 'Guinean Franc',
                    symbol_native: 'FG',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'GNF',
                    name_plural: 'Guinean francs',
                },
            },
            {
                name: 'Gambia',
                isoCode: 'GM',
                phoneCode: '220',
                flag: {
                    emoji: '🇬🇲',
                    unicode: 'U+1F1EC U+1F1F2',
                },
                currency: {
                    symbol: 'D',
                    name: 'Gambian Dalasi',
                    symbol_native: 'D',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GMD',
                    name_plural: 'Gambian Dalasi',
                },
            },
            {
                name: 'Greenland',
                isoCode: 'GL',
                phoneCode: '299',
                flag: {
                    emoji: '🇬🇱',
                    unicode: 'U+1F1EC U+1F1F1',
                },
                currency: {
                    symbol: 'Dkr',
                    name: 'Danish Krone',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'DKK',
                    name_plural: 'Danish kroner',
                },
            },
            {
                name: 'Gibraltar',
                isoCode: 'GI',
                phoneCode: '350',
                flag: {
                    emoji: '🇬🇮',
                    unicode: 'U+1F1EC U+1F1EE',
                },
                currency: {
                    symbol: '£',
                    name: 'Gibraltar Pound',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GIP',
                    name_plural: 'Gibraltar Pound',
                },
            },
            {
                name: 'Ghana',
                isoCode: 'GH',
                phoneCode: '233',
                flag: {
                    emoji: '🇬🇭',
                    unicode: 'U+1F1EC U+1F1ED',
                },
                currency: {
                    symbol: 'GH₵',
                    name: 'Ghanaian Cedi',
                    symbol_native: 'GH₵',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GHS',
                    name_plural: 'Ghanaian cedis',
                },
            },
            {
                name: 'Oman',
                isoCode: 'OM',
                phoneCode: '968',
                flag: {
                    emoji: '🇴🇲',
                    unicode: 'U+1F1F4 U+1F1F2',
                },
                currency: {
                    symbol: 'OMR',
                    name: 'Omani Rial',
                    symbol_native: 'ر.ع.‏',
                    decimal_digits: 3,
                    rounding: 0,
                    code: 'OMR',
                    name_plural: 'Omani rials',
                },
            },
            {
                name: 'Tunisia',
                isoCode: 'TN',
                phoneCode: '216',
                flag: {
                    emoji: '🇹🇳',
                    unicode: 'U+1F1F9 U+1F1F3',
                },
                currency: {
                    symbol: 'DT',
                    name: 'Tunisian Dinar',
                    symbol_native: 'د.ت.‏',
                    decimal_digits: 3,
                    rounding: 0,
                    code: 'TND',
                    name_plural: 'Tunisian dinars',
                },
            },
            {
                name: 'Jordan',
                isoCode: 'JO',
                phoneCode: '962',
                flag: {
                    emoji: '🇯🇴',
                    unicode: 'U+1F1EF U+1F1F4',
                },
                currency: {
                    symbol: 'JD',
                    name: 'Jordanian Dinar',
                    symbol_native: 'د.أ.‏',
                    decimal_digits: 3,
                    rounding: 0,
                    code: 'JOD',
                    name_plural: 'Jordanian dinars',
                },
            },
            {
                name: 'Croatia',
                isoCode: 'HR',
                phoneCode: '385',
                flag: {
                    emoji: '🇭🇷',
                    unicode: 'U+1F1ED U+1F1F7',
                },
                currency: {
                    symbol: 'kn',
                    name: 'Croatian Kuna',
                    symbol_native: 'kn',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'HRK',
                    name_plural: 'Croatian kunas',
                },
            },
            {
                name: 'Haiti',
                isoCode: 'HT',
                phoneCode: '509',
                flag: {
                    emoji: '🇭🇹',
                    unicode: 'U+1F1ED U+1F1F9',
                },
                currency: {
                    symbol: 'G',
                    name: 'Haitian Gourde',
                    symbol_native: 'G',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'HTG',
                    name_plural: 'Haitian Gourde',
                },
            },
            {
                name: 'Hungary',
                isoCode: 'HU',
                phoneCode: '36',
                flag: {
                    emoji: '🇭🇺',
                    unicode: 'U+1F1ED U+1F1FA',
                },
                currency: {
                    symbol: 'Ft',
                    name: 'Hungarian Forint',
                    symbol_native: 'Ft',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'HUF',
                    name_plural: 'Hungarian forints',
                },
            },
            {
                name: 'Hong Kong',
                isoCode: 'HK',
                phoneCode: '852',
                flag: {
                    emoji: '🇭🇰',
                    unicode: 'U+1F1ED U+1F1F0',
                },
                currency: {
                    symbol: 'HK$',
                    name: 'Hong Kong Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'HKD',
                    name_plural: 'Hong Kong dollars',
                },
            },
            {
                name: 'Honduras',
                isoCode: 'HN',
                phoneCode: '504',
                flag: {
                    emoji: '🇭🇳',
                    unicode: 'U+1F1ED U+1F1F3',
                },
                currency: {
                    symbol: 'HNL',
                    name: 'Honduran Lempira',
                    symbol_native: 'L',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'HNL',
                    name_plural: 'Honduran lempiras',
                },
            },
            {
                name: 'Heard Island and McDonald Islands',
                isoCode: 'HM',
                phoneCode: ' ',
                flag: {
                    emoji: '🇭🇲',
                    unicode: 'U+1F1ED U+1F1F2',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Venezuela',
                isoCode: 'VE',
                phoneCode: '58',
                flag: {
                    emoji: '🇻🇪',
                    unicode: 'U+1F1FB U+1F1EA',
                },
                currency: {
                    symbol: 'Bs.F.',
                    name: 'Venezuelan Bolívar',
                    symbol_native: 'Bs.F.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'VEF',
                    name_plural: 'Venezuelan bolívars',
                },
            },
            {
                name: 'Puerto Rico',
                isoCode: 'PR',
                phoneCode: '+1-787 and 1-939',
                flag: {
                    emoji: '🇵🇷',
                    unicode: 'U+1F1F5 U+1F1F7',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Palestinian',
                isoCode: 'PS',
                phoneCode: '970',
                flag: {
                    emoji: '🇵🇸',
                    unicode: 'U+1F1F5 U+1F1F8',
                },
                currency: {
                    symbol: 'PP',
                    name: 'Palestine pound',
                    symbol_native: 'جنيه',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'PPP',
                    name_plural: 'Palestine pound',
                },
            },
            {
                name: 'Palau',
                isoCode: 'PW',
                phoneCode: '680',
                flag: {
                    emoji: '🇵🇼',
                    unicode: 'U+1F1F5 U+1F1FC',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Portugal',
                isoCode: 'PT',
                phoneCode: '351',
                flag: {
                    emoji: '🇵🇹',
                    unicode: 'U+1F1F5 U+1F1F9',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Svalbard and Jan Mayen',
                isoCode: 'SJ',
                phoneCode: '47',
                flag: {
                    emoji: '🇸🇯',
                    unicode: 'U+1F1F8 U+1F1EF',
                },
                currency: {
                    symbol: 'Nkr',
                    name: 'Norwegian Krone',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NOK',
                    name_plural: 'Norwegian kroner',
                },
            },
            {
                name: 'Paraguay',
                isoCode: 'PY',
                phoneCode: '595',
                flag: {
                    emoji: '🇵🇾',
                    unicode: 'U+1F1F5 U+1F1FE',
                },
                currency: {
                    symbol: '₲',
                    name: 'Paraguayan Guarani',
                    symbol_native: '₲',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'PYG',
                    name_plural: 'Paraguayan guaranis',
                },
            },
            {
                name: 'Iraq',
                isoCode: 'IQ',
                phoneCode: '964',
                flag: {
                    emoji: '🇮🇶',
                    unicode: 'U+1F1EE U+1F1F6',
                },
                currency: {
                    symbol: 'IQD',
                    name: 'Iraqi Dinar',
                    symbol_native: 'د.ع.‏',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'IQD',
                    name_plural: 'Iraqi dinars',
                },
            },
            {
                name: 'Panama',
                isoCode: 'PA',
                phoneCode: '507',
                flag: {
                    emoji: '🇵🇦',
                    unicode: 'U+1F1F5 U+1F1E6',
                },
                currency: {
                    symbol: 'B/.',
                    name: 'Panamanian Balboa',
                    symbol_native: 'B/.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'PAB',
                    name_plural: 'Panamanian balboas',
                },
            },
            {
                name: 'French Polynesia',
                isoCode: 'PF',
                phoneCode: '689',
                flag: {
                    emoji: '🇵🇫',
                    unicode: 'U+1F1F5 U+1F1EB',
                },
                currency: {
                    symbol: '₣',
                    name: 'CFP Franc',
                    symbol_native: '₣',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XPF',
                    name_plural: 'CFP Franc',
                },
            },
            {
                name: 'Papua New Guinea',
                isoCode: 'PG',
                phoneCode: '675',
                flag: {
                    emoji: '🇵🇬',
                    unicode: 'U+1F1F5 U+1F1EC',
                },
                currency: {
                    symbol: 'K',
                    name: 'Papua New Guinea Kina',
                    symbol_native: 'K',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'PGK',
                    name_plural: 'Papua New Guinea Kina',
                },
            },
            {
                name: 'Peru',
                isoCode: 'PE',
                phoneCode: '51',
                flag: {
                    emoji: '🇵🇪',
                    unicode: 'U+1F1F5 U+1F1EA',
                },
                currency: {
                    symbol: 'S/.',
                    name: 'Peruvian Nuevo Sol',
                    symbol_native: 'S/.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'PEN',
                    name_plural: 'Peruvian nuevos soles',
                },
            },
            {
                name: 'Pakistan',
                isoCode: 'PK',
                phoneCode: '92',
                flag: {
                    emoji: '🇵🇰',
                    unicode: 'U+1F1F5 U+1F1F0',
                },
                currency: {
                    symbol: 'PKRs',
                    name: 'Pakistani Rupee',
                    symbol_native: '₨',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'PKR',
                    name_plural: 'Pakistani rupees',
                },
            },
            {
                name: 'Philippines',
                isoCode: 'PH',
                phoneCode: '63',
                flag: {
                    emoji: '🇵🇭',
                    unicode: 'U+1F1F5 U+1F1ED',
                },
                currency: {
                    symbol: '₱',
                    name: 'Philippine Peso',
                    symbol_native: '₱',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'PHP',
                    name_plural: 'Philippine pesos',
                },
            },
            {
                name: 'Pitcairn',
                isoCode: 'PN',
                phoneCode: '870',
                flag: {
                    emoji: '🇵🇳',
                    unicode: 'U+1F1F5 U+1F1F3',
                },
                currency: {
                    symbol: 'NZ$',
                    name: 'New Zealand Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NZD',
                    name_plural: 'New Zealand dollars',
                },
            },
            {
                name: 'Poland',
                isoCode: 'PL',
                phoneCode: '48',
                flag: {
                    emoji: '🇵🇱',
                    unicode: 'U+1F1F5 U+1F1F1',
                },
                currency: {
                    symbol: 'zł',
                    name: 'Polish Zloty',
                    symbol_native: 'zł',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'PLN',
                    name_plural: 'Polish zlotys',
                },
            },
            {
                name: 'Saint Pierre and Miquelon',
                isoCode: 'PM',
                phoneCode: '508',
                flag: {
                    emoji: '🇵🇲',
                    unicode: 'U+1F1F5 U+1F1F2',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Zambia',
                isoCode: 'ZM',
                phoneCode: '260',
                flag: {
                    emoji: '🇿🇲',
                    unicode: 'U+1F1FF U+1F1F2',
                },
                currency: {
                    symbol: 'ZK',
                    name: 'Zambian Kwacha',
                    symbol_native: 'ZK',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'ZMK',
                    name_plural: 'Zambian kwachas',
                },
            },
            {
                name: 'Western Sahara',
                isoCode: 'EH',
                phoneCode: '212',
                flag: {
                    emoji: '🇪🇭',
                    unicode: 'U+1F1EA U+1F1ED',
                },
                currency: {
                    symbol: 'MAD',
                    name: 'Moroccan Dirham',
                    symbol_native: 'د.م.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MAD',
                    name_plural: 'Moroccan dirhams',
                },
            },
            {
                name: 'Estonia',
                isoCode: 'EE',
                phoneCode: '372',
                flag: {
                    emoji: '🇪🇪',
                    unicode: 'U+1F1EA U+1F1EA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Egypt',
                isoCode: 'EG',
                phoneCode: '20',
                flag: {
                    emoji: '🇪🇬',
                    unicode: 'U+1F1EA U+1F1EC',
                },
                currency: {
                    symbol: 'EGP',
                    name: 'Egyptian Pound',
                    symbol_native: 'ج.م.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EGP',
                    name_plural: 'Egyptian pounds',
                },
            },
            {
                name: 'South Africa',
                isoCode: 'ZA',
                phoneCode: '27',
                flag: {
                    emoji: '🇿🇦',
                    unicode: 'U+1F1FF U+1F1E6',
                },
                currency: {
                    symbol: 'R',
                    name: 'South African Rand',
                    symbol_native: 'R',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'ZAR',
                    name_plural: 'South African rand',
                },
            },
            {
                name: 'Ecuador',
                isoCode: 'EC',
                phoneCode: '593',
                flag: {
                    emoji: '🇪🇨',
                    unicode: 'U+1F1EA U+1F1E8',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Italy',
                isoCode: 'IT',
                phoneCode: '39',
                flag: {
                    emoji: '🇮🇹',
                    unicode: 'U+1F1EE U+1F1F9',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Vietnam',
                isoCode: 'VN',
                phoneCode: '84',
                flag: {
                    emoji: '🇻🇳',
                    unicode: 'U+1F1FB U+1F1F3',
                },
                currency: {
                    symbol: '₫',
                    name: 'Vietnamese Dong',
                    symbol_native: '₫',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'VND',
                    name_plural: 'Vietnamese dong',
                },
            },
            {
                name: 'Solomon Islands',
                isoCode: 'SB',
                phoneCode: '677',
                flag: {
                    emoji: '🇸🇧',
                    unicode: 'U+1F1F8 U+1F1E7',
                },
                currency: {
                    symbol: '$',
                    name: 'Solomon Islands Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SBD',
                    name_plural: 'Solomon Islands Dollar',
                },
            },
            {
                name: 'Ethiopia',
                isoCode: 'ET',
                phoneCode: '251',
                flag: {
                    emoji: '🇪🇹',
                    unicode: 'U+1F1EA U+1F1F9',
                },
                currency: {
                    symbol: 'Br',
                    name: 'Ethiopian Birr',
                    symbol_native: 'Br',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'ETB',
                    name_plural: 'Ethiopian birrs',
                },
            },
            {
                name: 'Somalia',
                isoCode: 'SO',
                phoneCode: '252',
                flag: {
                    emoji: '🇸🇴',
                    unicode: 'U+1F1F8 U+1F1F4',
                },
                currency: {
                    symbol: 'Ssh',
                    name: 'Somali Shilling',
                    symbol_native: 'Ssh',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'SOS',
                    name_plural: 'Somali shillings',
                },
            },
            {
                name: 'Zimbabwe',
                isoCode: 'ZW',
                phoneCode: '263',
                flag: {
                    emoji: '🇿🇼',
                    unicode: 'U+1F1FF U+1F1FC',
                },
                currency: {
                    symbol: 'ZWL$',
                    name: 'Zimbabwean Dollar',
                    symbol_native: 'ZWL$',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'ZWL',
                    name_plural: 'Zimbabwean Dollar',
                },
            },
            {
                name: 'Saudi Arabia',
                isoCode: 'SA',
                phoneCode: '966',
                flag: {
                    emoji: '🇸🇦',
                    unicode: 'U+1F1F8 U+1F1E6',
                },
                currency: {
                    symbol: 'SR',
                    name: 'Saudi Riyal',
                    symbol_native: 'ر.س.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SAR',
                    name_plural: 'Saudi riyals',
                },
            },
            {
                name: 'Spain',
                isoCode: 'ES',
                phoneCode: '34',
                flag: {
                    emoji: '🇪🇸',
                    unicode: 'U+1F1EA U+1F1F8',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Eritrea',
                isoCode: 'ER',
                phoneCode: '291',
                flag: {
                    emoji: '🇪🇷',
                    unicode: 'U+1F1EA U+1F1F7',
                },
                currency: {
                    symbol: 'Nfk',
                    name: 'Eritrean Nakfa',
                    symbol_native: 'Nfk',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'ERN',
                    name_plural: 'Eritrean nakfas',
                },
            },
            {
                name: 'Montenegro',
                isoCode: 'ME',
                phoneCode: '382',
                flag: {
                    emoji: '🇲🇪',
                    unicode: 'U+1F1F2 U+1F1EA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Moldova',
                isoCode: 'MD',
                phoneCode: '373',
                flag: {
                    emoji: '🇲🇩',
                    unicode: 'U+1F1F2 U+1F1E9',
                },
                currency: {
                    symbol: 'MDL',
                    name: 'Moldovan Leu',
                    symbol_native: 'MDL',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MDL',
                    name_plural: 'Moldovan lei',
                },
            },
            {
                name: 'Madagascar',
                isoCode: 'MG',
                phoneCode: '261',
                flag: {
                    emoji: '🇲🇬',
                    unicode: 'U+1F1F2 U+1F1EC',
                },
                currency: {
                    symbol: 'MGA',
                    name: 'Malagasy Ariary',
                    symbol_native: 'MGA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'MGA',
                    name_plural: 'Malagasy Ariaries',
                },
            },
            {
                name: 'Saint Martin',
                isoCode: 'MF',
                phoneCode: '590',
                flag: {
                    emoji: '🇲🇫',
                    unicode: 'U+1F1F2 U+1F1EB',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Morocco',
                isoCode: 'MA',
                phoneCode: '212',
                flag: {
                    emoji: '🇲🇦',
                    unicode: 'U+1F1F2 U+1F1E6',
                },
                currency: {
                    symbol: 'MAD',
                    name: 'Moroccan Dirham',
                    symbol_native: 'د.م.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MAD',
                    name_plural: 'Moroccan dirhams',
                },
            },
            {
                name: 'Monaco',
                isoCode: 'MC',
                phoneCode: '377',
                flag: {
                    emoji: '🇲🇨',
                    unicode: 'U+1F1F2 U+1F1E8',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Uzbekistan',
                isoCode: 'UZ',
                phoneCode: '998',
                flag: {
                    emoji: '🇺🇿',
                    unicode: 'U+1F1FA U+1F1FF',
                },
                currency: {
                    symbol: 'UZS',
                    name: 'Uzbekistan Som',
                    symbol_native: 'UZS',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'UZS',
                    name_plural: 'Uzbekistan som',
                },
            },
            {
                name: 'Myanmar',
                isoCode: 'MM',
                phoneCode: '95',
                flag: {
                    emoji: '🇲🇲',
                    unicode: 'U+1F1F2 U+1F1F2',
                },
                currency: {
                    symbol: 'MMK',
                    name: 'Myanma Kyat',
                    symbol_native: 'K',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'MMK',
                    name_plural: 'Myanma kyats',
                },
            },
            {
                name: 'Mali',
                isoCode: 'ML',
                phoneCode: '223',
                flag: {
                    emoji: '🇲🇱',
                    unicode: 'U+1F1F2 U+1F1F1',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Macao',
                isoCode: 'MO',
                phoneCode: '853',
                flag: {
                    emoji: '🇲🇴',
                    unicode: 'U+1F1F2 U+1F1F4',
                },
                currency: {
                    symbol: 'MOP$',
                    name: 'Macanese Pataca',
                    symbol_native: 'MOP$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MOP',
                    name_plural: 'Macanese patacas',
                },
            },
            {
                name: 'Mongolia',
                isoCode: 'MN',
                phoneCode: '976',
                flag: {
                    emoji: '🇲🇳',
                    unicode: 'U+1F1F2 U+1F1F3',
                },
                currency: {
                    symbol: '₮',
                    name: 'Mongolian Tugrik',
                    symbol_native: '₮',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MNT',
                    name_plural: 'Mongolian Tugrik',
                },
            },
            {
                name: 'Marshall Islands',
                isoCode: 'MH',
                phoneCode: '692',
                flag: {
                    emoji: '🇲🇭',
                    unicode: 'U+1F1F2 U+1F1ED',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Macedonia',
                isoCode: 'MK',
                phoneCode: '389',
                flag: {
                    emoji: '🇲🇰',
                    unicode: 'U+1F1F2 U+1F1F0',
                },
                currency: {
                    symbol: 'MKD',
                    name: 'Macedonian Denar',
                    symbol_native: 'MKD',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MKD',
                    name_plural: 'Macedonian denari',
                },
            },
            {
                name: 'Mauritius',
                isoCode: 'MU',
                phoneCode: '230',
                flag: {
                    emoji: '🇲🇺',
                    unicode: 'U+1F1F2 U+1F1FA',
                },
                currency: {
                    symbol: 'MURs',
                    name: 'Mauritian Rupee',
                    symbol_native: 'MURs',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'MUR',
                    name_plural: 'Mauritian rupees',
                },
            },
            {
                name: 'Malta',
                isoCode: 'MT',
                phoneCode: '356',
                flag: {
                    emoji: '🇲🇹',
                    unicode: 'U+1F1F2 U+1F1F9',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Malawi',
                isoCode: 'MW',
                phoneCode: '265',
                flag: {
                    emoji: '🇲🇼',
                    unicode: 'U+1F1F2 U+1F1FC',
                },
                currency: {
                    symbol: 'MK',
                    name: 'Malawian Kwacha',
                    symbol_native: 'MK',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MWK',
                    name_plural: 'Malawian Kwacha',
                },
            },
            {
                name: 'Maldives',
                isoCode: 'MV',
                phoneCode: '960',
                flag: {
                    emoji: '🇲🇻',
                    unicode: 'U+1F1F2 U+1F1FB',
                },
                currency: {
                    symbol: 'Rf',
                    name: 'Maldives Rufiyaa',
                    symbol_native: 'Rf',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MVR',
                    name_plural: 'Maldives Rufiyaa',
                },
            },
            {
                name: 'Martinique',
                isoCode: 'MQ',
                phoneCode: '596',
                flag: {
                    emoji: '🇲🇶',
                    unicode: 'U+1F1F2 U+1F1F6',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Northern Mariana Islands',
                isoCode: 'MP',
                phoneCode: '+1-670',
                flag: {
                    emoji: '🇲🇵',
                    unicode: 'U+1F1F2 U+1F1F5',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Montserrat',
                isoCode: 'MS',
                phoneCode: '+1-664',
                flag: {
                    emoji: '🇲🇸',
                    unicode: 'U+1F1F2 U+1F1F8',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'Mauritania',
                isoCode: 'MR',
                phoneCode: '222',
                flag: {
                    emoji: '🇲🇷',
                    unicode: 'U+1F1F2 U+1F1F7',
                },
                currency: {
                    symbol: 'UM',
                    name: 'Mauritanian Ouguiya',
                    symbol_native: 'UM',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MRO',
                    name_plural: 'Mauritanian Ouguiya',
                },
            },
            {
                name: 'Isle of Man',
                isoCode: 'IM',
                phoneCode: '+44-1624',
                flag: {
                    emoji: '🇮🇲',
                    unicode: 'U+1F1EE U+1F1F2',
                },
                currency: {
                    symbol: '£',
                    name: 'British Pound Sterling',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'GBP',
                    name_plural: 'British pounds sterling',
                },
            },
            {
                name: 'Uganda',
                isoCode: 'UG',
                phoneCode: '256',
                flag: {
                    emoji: '🇺🇬',
                    unicode: 'U+1F1FA U+1F1EC',
                },
                currency: {
                    symbol: 'USh',
                    name: 'Ugandan Shilling',
                    symbol_native: 'USh',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'UGX',
                    name_plural: 'Ugandan shillings',
                },
            },
            {
                name: 'Tanzania',
                isoCode: 'TZ',
                phoneCode: '255',
                flag: {
                    emoji: '🇹🇿',
                    unicode: 'U+1F1F9 U+1F1FF',
                },
                currency: {
                    symbol: 'TSh',
                    name: 'Tanzanian Shilling',
                    symbol_native: 'TSh',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'TZS',
                    name_plural: 'Tanzanian shillings',
                },
            },
            {
                name: 'Malaysia',
                isoCode: 'MY',
                phoneCode: '60',
                flag: {
                    emoji: '🇲🇾',
                    unicode: 'U+1F1F2 U+1F1FE',
                },
                currency: {
                    symbol: 'RM',
                    name: 'Malaysian Ringgit',
                    symbol_native: 'RM',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MYR',
                    name_plural: 'Malaysian ringgits',
                },
            },
            {
                name: 'Mexico',
                isoCode: 'MX',
                phoneCode: '52',
                flag: {
                    emoji: '🇲🇽',
                    unicode: 'U+1F1F2 U+1F1FD',
                },
                currency: {
                    symbol: 'MX$',
                    name: 'Mexican Peso',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MXN',
                    name_plural: 'Mexican pesos',
                },
            },
            {
                name: 'France',
                isoCode: 'FR',
                phoneCode: '33',
                flag: {
                    emoji: '🇫🇷',
                    unicode: 'U+1F1EB U+1F1F7',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'British Indian Ocean Territory',
                isoCode: 'IO',
                phoneCode: '246',
                flag: {
                    emoji: '🇮🇴',
                    unicode: 'U+1F1EE U+1F1F4',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Saint Helena',
                isoCode: 'SH',
                phoneCode: '290',
                flag: {
                    emoji: '🇸🇭',
                    unicode: 'U+1F1F8 U+1F1ED',
                },
                currency: {
                    symbol: '£',
                    name: 'Saint Helena Pound',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SHP',
                    name_plural: 'Saint Helena Pound',
                },
            },
            {
                name: 'Finland',
                isoCode: 'FI',
                phoneCode: '358',
                flag: {
                    emoji: '🇫🇮',
                    unicode: 'U+1F1EB U+1F1EE',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Fiji',
                isoCode: 'FJ',
                phoneCode: '679',
                flag: {
                    emoji: '🇫🇯',
                    unicode: 'U+1F1EB U+1F1EF',
                },
                currency: {
                    symbol: '$',
                    name: 'Fiji Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'FJD',
                    name_plural: 'Fiji Dollar',
                },
            },
            {
                name: 'Falkland Islands',
                isoCode: 'FK',
                phoneCode: '500',
                flag: {
                    emoji: '🇫🇰',
                    unicode: 'U+1F1EB U+1F1F0',
                },
                currency: {
                    symbol: '£',
                    name: 'Falkland Islands Pound',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'FKP',
                    name_plural: 'Falkland Islands Pound',
                },
            },
            {
                name: 'Micronesia',
                isoCode: 'FM',
                phoneCode: '691',
                flag: {
                    emoji: '🇫🇲',
                    unicode: 'U+1F1EB U+1F1F2',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Faroe Islands',
                isoCode: 'FO',
                phoneCode: '298',
                flag: {
                    emoji: '🇫🇴',
                    unicode: 'U+1F1EB U+1F1F4',
                },
                currency: {
                    symbol: 'Dkr',
                    name: 'Danish Krone',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'DKK',
                    name_plural: 'Danish kroner',
                },
            },
            {
                name: 'Nicaragua',
                isoCode: 'NI',
                phoneCode: '505',
                flag: {
                    emoji: '🇳🇮',
                    unicode: 'U+1F1F3 U+1F1EE',
                },
                currency: {
                    symbol: 'C$',
                    name: 'Nicaraguan Córdoba',
                    symbol_native: 'C$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NIO',
                    name_plural: 'Nicaraguan córdobas',
                },
            },
            {
                name: 'Netherlands',
                isoCode: 'NL',
                phoneCode: '31',
                flag: {
                    emoji: '🇳🇱',
                    unicode: 'U+1F1F3 U+1F1F1',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Norway',
                isoCode: 'NO',
                phoneCode: '47',
                flag: {
                    emoji: '🇳🇴',
                    unicode: 'U+1F1F3 U+1F1F4',
                },
                currency: {
                    symbol: 'Nkr',
                    name: 'Norwegian Krone',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NOK',
                    name_plural: 'Norwegian kroner',
                },
            },
            {
                name: 'Namibia',
                isoCode: 'NA',
                phoneCode: '264',
                flag: {
                    emoji: '🇳🇦',
                    unicode: 'U+1F1F3 U+1F1E6',
                },
                currency: {
                    symbol: 'N$',
                    name: 'Namibian Dollar',
                    symbol_native: 'N$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NAD',
                    name_plural: 'Namibian dollars',
                },
            },
            {
                name: 'Vanuatu',
                isoCode: 'VU',
                phoneCode: '678',
                flag: {
                    emoji: '🇻🇺',
                    unicode: 'U+1F1FB U+1F1FA',
                },
                currency: {
                    symbol: 'VT',
                    name: 'Vanuatu Vatu',
                    symbol_native: 'VT',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'VUV',
                    name_plural: 'Vanuatu Vatu',
                },
            },
            {
                name: 'New Caledonia',
                isoCode: 'NC',
                phoneCode: '687',
                flag: {
                    emoji: '🇳🇨',
                    unicode: 'U+1F1F3 U+1F1E8',
                },
                currency: {
                    symbol: '₣',
                    name: 'CFP Franc',
                    symbol_native: '₣',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XPF',
                    name_plural: 'CFP Franc',
                },
            },
            {
                name: 'Niger',
                isoCode: 'NE',
                phoneCode: '227',
                flag: {
                    emoji: '🇳🇪',
                    unicode: 'U+1F1F3 U+1F1EA',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Norfolk Island',
                isoCode: 'NF',
                phoneCode: '672',
                flag: {
                    emoji: '🇳🇫',
                    unicode: 'U+1F1F3 U+1F1EB',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Nigeria',
                isoCode: 'NG',
                phoneCode: '234',
                flag: {
                    emoji: '🇳🇬',
                    unicode: 'U+1F1F3 U+1F1EC',
                },
                currency: {
                    symbol: '₦',
                    name: 'Nigerian Naira',
                    symbol_native: '₦',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NGN',
                    name_plural: 'Nigerian nairas',
                },
            },
            {
                name: 'New Zealand',
                isoCode: 'NZ',
                phoneCode: '64',
                flag: {
                    emoji: '🇳🇿',
                    unicode: 'U+1F1F3 U+1F1FF',
                },
                currency: {
                    symbol: 'NZ$',
                    name: 'New Zealand Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NZD',
                    name_plural: 'New Zealand dollars',
                },
            },
            {
                name: 'Nepal',
                isoCode: 'NP',
                phoneCode: '977',
                flag: {
                    emoji: '🇳🇵',
                    unicode: 'U+1F1F3 U+1F1F5',
                },
                currency: {
                    symbol: 'NPRs',
                    name: 'Nepalese Rupee',
                    symbol_native: 'नेरू',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NPR',
                    name_plural: 'Nepalese rupees',
                },
            },
            {
                name: 'Nauru',
                isoCode: 'NR',
                phoneCode: '674',
                flag: {
                    emoji: '🇳🇷',
                    unicode: 'U+1F1F3 U+1F1F7',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Niue',
                isoCode: 'NU',
                phoneCode: '683',
                flag: {
                    emoji: '🇳🇺',
                    unicode: 'U+1F1F3 U+1F1FA',
                },
                currency: {
                    symbol: 'NZ$',
                    name: 'New Zealand Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NZD',
                    name_plural: 'New Zealand dollars',
                },
            },
            {
                name: 'Cook Islands',
                isoCode: 'CK',
                phoneCode: '682',
                flag: {
                    emoji: '🇨🇰',
                    unicode: 'U+1F1E8 U+1F1F0',
                },
                currency: {
                    symbol: 'NZ$',
                    name: 'New Zealand Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'NZD',
                    name_plural: 'New Zealand dollars',
                },
            },
            {
                name: 'Kosovo',
                isoCode: 'XK',
                phoneCode: '383',
                flag: {
                    emoji: '🇽🇰',
                    unicode: 'U+1F1FD U+1F1F0',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Ivory Coast',
                isoCode: 'CI',
                phoneCode: '225',
                flag: {
                    emoji: '🇨🇮',
                    unicode: 'U+1F1E8 U+1F1EE',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Switzerland',
                isoCode: 'CH',
                phoneCode: '41',
                flag: {
                    emoji: '🇨🇭',
                    unicode: 'U+1F1E8 U+1F1ED',
                },
                currency: {
                    symbol: 'CHF',
                    name: 'Swiss Franc',
                    symbol_native: 'CHF',
                    decimal_digits: 2,
                    rounding: 0.05,
                    code: 'CHF',
                    name_plural: 'Swiss francs',
                },
            },
            {
                name: 'Colombia',
                isoCode: 'CO',
                phoneCode: '57',
                flag: {
                    emoji: '🇨🇴',
                    unicode: 'U+1F1E8 U+1F1F4',
                },
                currency: {
                    symbol: 'CO$',
                    name: 'Colombian Peso',
                    symbol_native: '$',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'COP',
                    name_plural: 'Colombian pesos',
                },
            },
            {
                name: 'China',
                isoCode: 'CN',
                phoneCode: '86',
                flag: {
                    emoji: '🇨🇳',
                    unicode: 'U+1F1E8 U+1F1F3',
                },
                currency: {
                    symbol: 'CN¥',
                    name: 'Chinese Yuan',
                    symbol_native: 'CN¥',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'CNY',
                    name_plural: 'Chinese yuan',
                },
            },
            {
                name: 'Cameroon',
                isoCode: 'CM',
                phoneCode: '237',
                flag: {
                    emoji: '🇨🇲',
                    unicode: 'U+1F1E8 U+1F1F2',
                },
                currency: {
                    symbol: 'FCFA',
                    name: 'CFA Franc BEAC',
                    symbol_native: 'FCFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XAF',
                    name_plural: 'CFA francs BEAC',
                },
            },
            {
                name: 'Chile',
                isoCode: 'CL',
                phoneCode: '56',
                flag: {
                    emoji: '🇨🇱',
                    unicode: 'U+1F1E8 U+1F1F1',
                },
                currency: {
                    symbol: 'CL$',
                    name: 'Chilean Peso',
                    symbol_native: '$',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'CLP',
                    name_plural: 'Chilean pesos',
                },
            },
            {
                name: 'Cocos Islands',
                isoCode: 'CC',
                phoneCode: '61',
                flag: {
                    emoji: '🇨🇨',
                    unicode: 'U+1F1E8 U+1F1E8',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Canada',
                isoCode: 'CA',
                phoneCode: '1',
                flag: {
                    emoji: '🇨🇦',
                    unicode: 'U+1F1E8 U+1F1E6',
                },
                currency: {
                    symbol: 'CA$',
                    name: 'Canadian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'CAD',
                    name_plural: 'Canadian dollars',
                },
            },
            {
                name: 'Republic of the Congo',
                isoCode: 'CG',
                phoneCode: '242',
                flag: {
                    emoji: '🇨🇬',
                    unicode: 'U+1F1E8 U+1F1EC',
                },
                currency: {
                    symbol: 'FCFA',
                    name: 'CFA Franc BEAC',
                    symbol_native: 'FCFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XAF',
                    name_plural: 'CFA francs BEAC',
                },
            },
            {
                name: 'Central African Republic',
                isoCode: 'CF',
                phoneCode: '236',
                flag: {
                    emoji: '🇨🇫',
                    unicode: 'U+1F1E8 U+1F1EB',
                },
                currency: {
                    symbol: 'FCFA',
                    name: 'CFA Franc BEAC',
                    symbol_native: 'FCFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XAF',
                    name_plural: 'CFA francs BEAC',
                },
            },
            {
                name: 'Democratic Republic of the Congo',
                isoCode: 'CD',
                phoneCode: '243',
                flag: {
                    emoji: '🇨🇩',
                    unicode: 'U+1F1E8 U+1F1E9',
                },
                currency: {
                    symbol: 'CDF',
                    name: 'Congolese Franc',
                    symbol_native: 'FrCD',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'CDF',
                    name_plural: 'Congolese francs',
                },
            },
            {
                name: 'Czech Republic',
                isoCode: 'CZ',
                phoneCode: '420',
                flag: {
                    emoji: '🇨🇿',
                    unicode: 'U+1F1E8 U+1F1FF',
                },
                currency: {
                    symbol: 'Kč',
                    name: 'Czech Republic Koruna',
                    symbol_native: 'Kč',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'CZK',
                    name_plural: 'Czech Republic korunas',
                },
            },
            {
                name: 'Cyprus',
                isoCode: 'CY',
                phoneCode: '357',
                flag: {
                    emoji: '🇨🇾',
                    unicode: 'U+1F1E8 U+1F1FE',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Christmas Island',
                isoCode: 'CX',
                phoneCode: '61',
                flag: {
                    emoji: '🇨🇽',
                    unicode: 'U+1F1E8 U+1F1FD',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Costa Rica',
                isoCode: 'CR',
                phoneCode: '506',
                flag: {
                    emoji: '🇨🇷',
                    unicode: 'U+1F1E8 U+1F1F7',
                },
                currency: {
                    symbol: '₡',
                    name: 'Costa Rican Colón',
                    symbol_native: '₡',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'CRC',
                    name_plural: 'Costa Rican colóns',
                },
            },
            {
                name: 'Curacao',
                isoCode: 'CW',
                phoneCode: '599',
                flag: {
                    emoji: '🇨🇼',
                    unicode: 'U+1F1E8 U+1F1FC',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Cape Verde',
                isoCode: 'CV',
                phoneCode: '238',
                flag: {
                    emoji: '🇨🇻',
                    unicode: 'U+1F1E8 U+1F1FB',
                },
                currency: {
                    symbol: 'CV$',
                    name: 'Cape Verdean Escudo',
                    symbol_native: 'CV$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'CVE',
                    name_plural: 'Cape Verdean escudos',
                },
            },
            {
                name: 'Cuba',
                isoCode: 'CU',
                phoneCode: '53',
                flag: {
                    emoji: '🇨🇺',
                    unicode: 'U+1F1E8 U+1F1FA',
                },
                currency: {
                    symbol: '$',
                    name: 'Cuban Peso',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'CUP',
                    name_plural: 'Cuban Peso',
                },
            },
            {
                name: 'Swaziland',
                isoCode: 'SZ',
                phoneCode: '268',
                flag: {
                    emoji: '🇸🇿',
                    unicode: 'U+1F1F8 U+1F1FF',
                },
                currency: {
                    symbol: 'E',
                    name: 'Swazi Lilangeni',
                    symbol_native: 'E',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SZL',
                    name_plural: 'Swazi Lilangeni',
                },
            },
            {
                name: 'Syria',
                isoCode: 'SY',
                phoneCode: '963',
                flag: {
                    emoji: '🇸🇾',
                    unicode: 'U+1F1F8 U+1F1FE',
                },
                currency: {
                    symbol: 'SY£',
                    name: 'Syrian Pound',
                    symbol_native: 'ل.س.‏',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'SYP',
                    name_plural: 'Syrian pounds',
                },
            },
            {
                name: 'Sint Maarten',
                isoCode: 'SX',
                phoneCode: '599',
                flag: {
                    emoji: '🇸🇽',
                    unicode: 'U+1F1F8 U+1F1FD',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Kyrgyzstan',
                isoCode: 'KG',
                phoneCode: '996',
                flag: {
                    emoji: '🇰🇬',
                    unicode: 'U+1F1F0 U+1F1EC',
                },
                currency: {
                    symbol: 'лв',
                    name: 'Kyrgyzstani Som',
                    symbol_native: 'лв',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'KGS',
                    name_plural: 'Kyrgyzstani Som',
                },
            },
            {
                name: 'Kenya',
                isoCode: 'KE',
                phoneCode: '254',
                flag: {
                    emoji: '🇰🇪',
                    unicode: 'U+1F1F0 U+1F1EA',
                },
                currency: {
                    symbol: 'Ksh',
                    name: 'Kenyan Shilling',
                    symbol_native: 'Ksh',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'KES',
                    name_plural: 'Kenyan shillings',
                },
            },
            {
                name: 'South Sudan',
                isoCode: 'SS',
                phoneCode: '211',
                flag: {
                    emoji: '🇸🇸',
                    unicode: 'U+1F1F8 U+1F1F8',
                },
                currency: {
                    symbol: '£',
                    name: 'South Sudanese pound',
                    symbol_native: '£',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SSP',
                    name_plural: 'South Sudanese pound',
                },
            },
            {
                name: 'Suriname',
                isoCode: 'SR',
                phoneCode: '597',
                flag: {
                    emoji: '🇸🇷',
                    unicode: 'U+1F1F8 U+1F1F7',
                },
                currency: {
                    symbol: '$',
                    name: 'Suriname Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SRD',
                    name_plural: 'Suriname Dollar',
                },
            },
            {
                name: 'Kiribati',
                isoCode: 'KI',
                phoneCode: '686',
                flag: {
                    emoji: '🇰🇮',
                    unicode: 'U+1F1F0 U+1F1EE',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Cambodia',
                isoCode: 'KH',
                phoneCode: '855',
                flag: {
                    emoji: '🇰🇭',
                    unicode: 'U+1F1F0 U+1F1ED',
                },
                currency: {
                    symbol: 'KHR',
                    name: 'Cambodian Riel',
                    symbol_native: '៛',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'KHR',
                    name_plural: 'Cambodian riels',
                },
            },
            {
                name: 'Saint Kitts and Nevis',
                isoCode: 'KN',
                phoneCode: '+1-869',
                flag: {
                    emoji: '🇰🇳',
                    unicode: 'U+1F1F0 U+1F1F3',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'Comoros',
                isoCode: 'KM',
                phoneCode: '269',
                flag: {
                    emoji: '🇰🇲',
                    unicode: 'U+1F1F0 U+1F1F2',
                },
                currency: {
                    symbol: 'CF',
                    name: 'Comorian Franc',
                    symbol_native: 'FC',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'KMF',
                    name_plural: 'Comorian francs',
                },
            },
            {
                name: 'Sao Tome and Principe',
                isoCode: 'ST',
                phoneCode: '239',
                flag: {
                    emoji: '🇸🇹',
                    unicode: 'U+1F1F8 U+1F1F9',
                },
                currency: {
                    symbol: 'Db',
                    name: 'Sao Tome Dobra',
                    symbol_native: 'Db',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'STD',
                    name_plural: 'Sao Tome Dobra',
                },
            },
            {
                name: 'Slovakia',
                isoCode: 'SK',
                phoneCode: '421',
                flag: {
                    emoji: '🇸🇰',
                    unicode: 'U+1F1F8 U+1F1F0',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'South Korea',
                isoCode: 'KR',
                phoneCode: '82',
                flag: {
                    emoji: '🇰🇷',
                    unicode: 'U+1F1F0 U+1F1F7',
                },
                currency: {
                    symbol: '₩',
                    name: 'South Korean Won',
                    symbol_native: '₩',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'KRW',
                    name_plural: 'South Korean won',
                },
            },
            {
                name: 'Slovenia',
                isoCode: 'SI',
                phoneCode: '386',
                flag: {
                    emoji: '🇸🇮',
                    unicode: 'U+1F1F8 U+1F1EE',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'North Korea',
                isoCode: 'KP',
                phoneCode: '850',
                flag: {
                    emoji: '🇰🇵',
                    unicode: 'U+1F1F0 U+1F1F5',
                },
                currency: {
                    symbol: '₩',
                    name: 'North Korean Won',
                    symbol_native: '₩',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'KPW',
                    name_plural: 'North Korean Won',
                },
            },
            {
                name: 'Kuwait',
                isoCode: 'KW',
                phoneCode: '965',
                flag: {
                    emoji: '🇰🇼',
                    unicode: 'U+1F1F0 U+1F1FC',
                },
                currency: {
                    symbol: 'KD',
                    name: 'Kuwaiti Dinar',
                    symbol_native: 'د.ك.‏',
                    decimal_digits: 3,
                    rounding: 0,
                    code: 'KWD',
                    name_plural: 'Kuwaiti dinars',
                },
            },
            {
                name: 'Senegal',
                isoCode: 'SN',
                phoneCode: '221',
                flag: {
                    emoji: '🇸🇳',
                    unicode: 'U+1F1F8 U+1F1F3',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'San Marino',
                isoCode: 'SM',
                phoneCode: '378',
                flag: {
                    emoji: '🇸🇲',
                    unicode: 'U+1F1F8 U+1F1F2',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Sierra Leone',
                isoCode: 'SL',
                phoneCode: '232',
                flag: {
                    emoji: '🇸🇱',
                    unicode: 'U+1F1F8 U+1F1F1',
                },
                currency: {
                    symbol: 'Le',
                    name: 'Sierra Leonean Leone',
                    symbol_native: 'Le',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SLL',
                    name_plural: 'Sierra Leonean Leone',
                },
            },
            {
                name: 'Seychelles',
                isoCode: 'SC',
                phoneCode: '248',
                flag: {
                    emoji: '🇸🇨',
                    unicode: 'U+1F1F8 U+1F1E8',
                },
                currency: {
                    symbol: '₨',
                    name: 'Seychelles Rupee',
                    symbol_native: '₨',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SCR',
                    name_plural: 'Seychelles Rupee',
                },
            },
            {
                name: 'Kazakhstan',
                isoCode: 'KZ',
                phoneCode: '7',
                flag: {
                    emoji: '🇰🇿',
                    unicode: 'U+1F1F0 U+1F1FF',
                },
                currency: {
                    symbol: 'KZT',
                    name: 'Kazakhstani Tenge',
                    symbol_native: 'тңг.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'KZT',
                    name_plural: 'Kazakhstani tenges',
                },
            },
            {
                name: 'Cayman Islands',
                isoCode: 'KY',
                phoneCode: '+1-345',
                flag: {
                    emoji: '🇰🇾',
                    unicode: 'U+1F1F0 U+1F1FE',
                },
                currency: {
                    symbol: '$',
                    name: 'Cayman Islands Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'KYD',
                    name_plural: 'Cayman Islands Dollar',
                },
            },
            {
                name: 'Singapore',
                isoCode: 'SG',
                phoneCode: '65',
                flag: {
                    emoji: '🇸🇬',
                    unicode: 'U+1F1F8 U+1F1EC',
                },
                currency: {
                    symbol: 'S$',
                    name: 'Singapore Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SGD',
                    name_plural: 'Singapore dollars',
                },
            },
            {
                name: 'Sweden',
                isoCode: 'SE',
                phoneCode: '46',
                flag: {
                    emoji: '🇸🇪',
                    unicode: 'U+1F1F8 U+1F1EA',
                },
                currency: {
                    symbol: 'Skr',
                    name: 'Swedish Krona',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SEK',
                    name_plural: 'Swedish kronor',
                },
            },
            {
                name: 'Sudan',
                isoCode: 'SD',
                phoneCode: '249',
                flag: {
                    emoji: '🇸🇩',
                    unicode: 'U+1F1F8 U+1F1E9',
                },
                currency: {
                    symbol: 'SDG',
                    name: 'Sudanese Pound',
                    symbol_native: 'SDG',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'SDG',
                    name_plural: 'Sudanese pounds',
                },
            },
            {
                name: 'Dominican Republic',
                isoCode: 'DO',
                phoneCode: '+1-809 and 1-829',
                flag: {
                    emoji: '🇩🇴',
                    unicode: 'U+1F1E9 U+1F1F4',
                },
                currency: {
                    symbol: 'RD$',
                    name: 'Dominican Peso',
                    symbol_native: 'RD$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'DOP',
                    name_plural: 'Dominican pesos',
                },
            },
            {
                name: 'Dominica',
                isoCode: 'DM',
                phoneCode: '+1-767',
                flag: {
                    emoji: '🇩🇲',
                    unicode: 'U+1F1E9 U+1F1F2',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'Djibouti',
                isoCode: 'DJ',
                phoneCode: '253',
                flag: {
                    emoji: '🇩🇯',
                    unicode: 'U+1F1E9 U+1F1EF',
                },
                currency: {
                    symbol: 'Fdj',
                    name: 'Djiboutian Franc',
                    symbol_native: 'Fdj',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'DJF',
                    name_plural: 'Djiboutian francs',
                },
            },
            {
                name: 'Denmark',
                isoCode: 'DK',
                phoneCode: '45',
                flag: {
                    emoji: '🇩🇰',
                    unicode: 'U+1F1E9 U+1F1F0',
                },
                currency: {
                    symbol: 'Dkr',
                    name: 'Danish Krone',
                    symbol_native: 'kr',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'DKK',
                    name_plural: 'Danish kroner',
                },
            },
            {
                name: 'British Virgin Islands',
                isoCode: 'VG',
                phoneCode: '+1-284',
                flag: {
                    emoji: '🇻🇬',
                    unicode: 'U+1F1FB U+1F1EC',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Germany',
                isoCode: 'DE',
                phoneCode: '49',
                flag: {
                    emoji: '🇩🇪',
                    unicode: 'U+1F1E9 U+1F1EA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Yemen',
                isoCode: 'YE',
                phoneCode: '967',
                flag: {
                    emoji: '🇾🇪',
                    unicode: 'U+1F1FE U+1F1EA',
                },
                currency: {
                    symbol: 'YR',
                    name: 'Yemeni Rial',
                    symbol_native: 'ر.ي.‏',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'YER',
                    name_plural: 'Yemeni rials',
                },
            },
            {
                name: 'Algeria',
                isoCode: 'DZ',
                phoneCode: '213',
                flag: {
                    emoji: '🇩🇿',
                    unicode: 'U+1F1E9 U+1F1FF',
                },
                currency: {
                    symbol: 'DA',
                    name: 'Algerian Dinar',
                    symbol_native: 'د.ج.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'DZD',
                    name_plural: 'Algerian dinars',
                },
            },
            {
                name: 'United States',
                isoCode: 'US',
                phoneCode: '1',
                flag: {
                    emoji: '🇺🇸',
                    unicode: 'U+1F1FA U+1F1F8',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Uruguay',
                isoCode: 'UY',
                phoneCode: '598',
                flag: {
                    emoji: '🇺🇾',
                    unicode: 'U+1F1FA U+1F1FE',
                },
                currency: {
                    symbol: '$U',
                    name: 'Uruguayan Peso',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'UYU',
                    name_plural: 'Uruguayan pesos',
                },
            },
            {
                name: 'Mayotte',
                isoCode: 'YT',
                phoneCode: '262',
                flag: {
                    emoji: '🇾🇹',
                    unicode: 'U+1F1FE U+1F1F9',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Lebanon',
                isoCode: 'LB',
                phoneCode: '961',
                flag: {
                    emoji: '🇱🇧',
                    unicode: 'U+1F1F1 U+1F1E7',
                },
                currency: {
                    symbol: 'LB£',
                    name: 'Lebanese Pound',
                    symbol_native: 'ل.ل.‏',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'LBP',
                    name_plural: 'Lebanese pounds',
                },
            },
            {
                name: 'Saint Lucia',
                isoCode: 'LC',
                phoneCode: '+1-758',
                flag: {
                    emoji: '🇱🇨',
                    unicode: 'U+1F1F1 U+1F1E8',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'Laos',
                isoCode: 'LA',
                phoneCode: '856',
                flag: {
                    emoji: '🇱🇦',
                    unicode: 'U+1F1F1 U+1F1E6',
                },
                currency: {
                    symbol: '₭',
                    name: 'Lao Kip',
                    symbol_native: '₭',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'LAK',
                    name_plural: 'Lao Kip',
                },
            },
            {
                name: 'Tuvalu',
                isoCode: 'TV',
                phoneCode: '688',
                flag: {
                    emoji: '🇹🇻',
                    unicode: 'U+1F1F9 U+1F1FB',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Taiwan',
                isoCode: 'TW',
                phoneCode: '886',
                flag: {
                    emoji: '🇹🇼',
                    unicode: 'U+1F1F9 U+1F1FC',
                },
                currency: {
                    symbol: 'NT$',
                    name: 'New Taiwan Dollar',
                    symbol_native: 'NT$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'TWD',
                    name_plural: 'New Taiwan dollars',
                },
            },
            {
                name: 'Trinidad and Tobago',
                isoCode: 'TT',
                phoneCode: '+1-868',
                flag: {
                    emoji: '🇹🇹',
                    unicode: 'U+1F1F9 U+1F1F9',
                },
                currency: {
                    symbol: 'TT$',
                    name: 'Trinidad and Tobago Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'TTD',
                    name_plural: 'Trinidad and Tobago dollars',
                },
            },
            {
                name: 'Turkey',
                isoCode: 'TR',
                phoneCode: '90',
                flag: {
                    emoji: '🇹🇷',
                    unicode: 'U+1F1F9 U+1F1F7',
                },
                currency: {
                    symbol: 'TL',
                    name: 'Turkish Lira',
                    symbol_native: 'TL',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'TRY',
                    name_plural: 'Turkish Lira',
                },
            },
            {
                name: 'Sri Lanka',
                isoCode: 'LK',
                phoneCode: '94',
                flag: {
                    emoji: '🇱🇰',
                    unicode: 'U+1F1F1 U+1F1F0',
                },
                currency: {
                    symbol: 'SLRs',
                    name: 'Sri Lankan Rupee',
                    symbol_native: 'SL Re',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'LKR',
                    name_plural: 'Sri Lankan rupees',
                },
            },
            {
                name: 'Liechtenstein',
                isoCode: 'LI',
                phoneCode: '423',
                flag: {
                    emoji: '🇱🇮',
                    unicode: 'U+1F1F1 U+1F1EE',
                },
                currency: {
                    symbol: 'CHF',
                    name: 'Swiss Franc',
                    symbol_native: 'CHF',
                    decimal_digits: 2,
                    rounding: 0.05,
                    code: 'CHF',
                    name_plural: 'Swiss francs',
                },
            },
            {
                name: 'Latvia',
                isoCode: 'LV',
                phoneCode: '371',
                flag: {
                    emoji: '🇱🇻',
                    unicode: 'U+1F1F1 U+1F1FB',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Tonga',
                isoCode: 'TO',
                phoneCode: '676',
                flag: {
                    emoji: '🇹🇴',
                    unicode: 'U+1F1F9 U+1F1F4',
                },
                currency: {
                    symbol: 'T$',
                    name: 'Tongan Paʻanga',
                    symbol_native: 'T$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'TOP',
                    name_plural: 'Tongan paʻanga',
                },
            },
            {
                name: 'Lithuania',
                isoCode: 'LT',
                phoneCode: '370',
                flag: {
                    emoji: '🇱🇹',
                    unicode: 'U+1F1F1 U+1F1F9',
                },
                currency: {
                    symbol: 'Lt',
                    name: 'Lithuanian Litas',
                    symbol_native: 'Lt',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'LTL',
                    name_plural: 'Lithuanian litai',
                },
            },
            {
                name: 'Luxembourg',
                isoCode: 'LU',
                phoneCode: '352',
                flag: {
                    emoji: '🇱🇺',
                    unicode: 'U+1F1F1 U+1F1FA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Liberia',
                isoCode: 'LR',
                phoneCode: '231',
                flag: {
                    emoji: '🇱🇷',
                    unicode: 'U+1F1F1 U+1F1F7',
                },
                currency: {
                    symbol: '$',
                    name: 'Liberian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'LRD',
                    name_plural: 'Liberian Dollar',
                },
            },
            {
                name: 'Lesotho',
                isoCode: 'LS',
                phoneCode: '266',
                flag: {
                    emoji: '🇱🇸',
                    unicode: 'U+1F1F1 U+1F1F8',
                },
                currency: {
                    symbol: 'L',
                    name: 'Lesotho Loti',
                    symbol_native: 'L',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'LSL',
                    name_plural: 'Lesotho Loti',
                },
            },
            {
                name: 'Thailand',
                isoCode: 'TH',
                phoneCode: '66',
                flag: {
                    emoji: '🇹🇭',
                    unicode: 'U+1F1F9 U+1F1ED',
                },
                currency: {
                    symbol: '฿',
                    name: 'Thai Baht',
                    symbol_native: '฿',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'THB',
                    name_plural: 'Thai baht',
                },
            },
            {
                name: 'French Southern Territories',
                isoCode: 'TF',
                phoneCode: '262',
                flag: {
                    emoji: '🇹🇫',
                    unicode: 'U+1F1F9 U+1F1EB',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Togo',
                isoCode: 'TG',
                phoneCode: '228',
                flag: {
                    emoji: '🇹🇬',
                    unicode: 'U+1F1F9 U+1F1EC',
                },
                currency: {
                    symbol: 'CFA',
                    name: 'CFA Franc BCEAO',
                    symbol_native: 'CFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XOF',
                    name_plural: 'CFA francs BCEAO',
                },
            },
            {
                name: 'Chad',
                isoCode: 'TD',
                phoneCode: '235',
                flag: {
                    emoji: '🇹🇩',
                    unicode: 'U+1F1F9 U+1F1E9',
                },
                currency: {
                    symbol: 'FCFA',
                    name: 'CFA Franc BEAC',
                    symbol_native: 'FCFA',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'XAF',
                    name_plural: 'CFA francs BEAC',
                },
            },
            {
                name: 'Turks and Caicos Islands',
                isoCode: 'TC',
                phoneCode: '+1-649',
                flag: {
                    emoji: '🇹🇨',
                    unicode: 'U+1F1F9 U+1F1E8',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Libya',
                isoCode: 'LY',
                phoneCode: '218',
                flag: {
                    emoji: '🇱🇾',
                    unicode: 'U+1F1F1 U+1F1FE',
                },
                currency: {
                    symbol: 'LD',
                    name: 'Libyan Dinar',
                    symbol_native: 'د.ل.‏',
                    decimal_digits: 3,
                    rounding: 0,
                    code: 'LYD',
                    name_plural: 'Libyan dinars',
                },
            },
            {
                name: 'Vatican',
                isoCode: 'VA',
                phoneCode: '379',
                flag: {
                    emoji: '🇻🇦',
                    unicode: 'U+1F1FB U+1F1E6',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Saint Vincent and the Grenadines',
                isoCode: 'VC',
                phoneCode: '+1-784',
                flag: {
                    emoji: '🇻🇨',
                    unicode: 'U+1F1FB U+1F1E8',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'United Arab Emirates',
                isoCode: 'AE',
                phoneCode: '971',
                flag: {
                    emoji: '🇦🇪',
                    unicode: 'U+1F1E6 U+1F1EA',
                },
                currency: {
                    symbol: 'AED',
                    name: 'United Arab Emirates Dirham',
                    symbol_native: 'د.إ.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AED',
                    name_plural: 'UAE dirhams',
                },
            },
            {
                name: 'Andorra',
                isoCode: 'AD',
                phoneCode: '376',
                flag: {
                    emoji: '🇦🇩',
                    unicode: 'U+1F1E6 U+1F1E9',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Antigua and Barbuda',
                isoCode: 'AG',
                phoneCode: '+1-268',
                flag: {
                    emoji: '🇦🇬',
                    unicode: 'U+1F1E6 U+1F1EC',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'Afghanistan',
                isoCode: 'AF',
                phoneCode: '93',
                flag: {
                    emoji: '🇦🇫',
                    unicode: 'U+1F1E6 U+1F1EB',
                },
                currency: {
                    symbol: 'Af',
                    name: 'Afghan Afghani',
                    symbol_native: '؋',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'AFN',
                    name_plural: 'Afghan Afghanis',
                },
            },
            {
                name: 'Anguilla',
                isoCode: 'AI',
                phoneCode: '+1-264',
                flag: {
                    emoji: '🇦🇮',
                    unicode: 'U+1F1E6 U+1F1EE',
                },
                currency: {
                    symbol: '$',
                    name: 'East Caribbean Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'XCD',
                    name_plural: 'East Caribbean Dollar',
                },
            },
            {
                name: 'U.S. Virgin Islands',
                isoCode: 'VI',
                phoneCode: '+1-340',
                flag: {
                    emoji: '🇻🇮',
                    unicode: 'U+1F1FB U+1F1EE',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Iceland',
                isoCode: 'IS',
                phoneCode: '354',
                flag: {
                    emoji: '🇮🇸',
                    unicode: 'U+1F1EE U+1F1F8',
                },
                currency: {
                    symbol: 'Ikr',
                    name: 'Icelandic Króna',
                    symbol_native: 'kr',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'ISK',
                    name_plural: 'Icelandic krónur',
                },
            },
            {
                name: 'Iran',
                isoCode: 'IR',
                phoneCode: '98',
                flag: {
                    emoji: '🇮🇷',
                    unicode: 'U+1F1EE U+1F1F7',
                },
                currency: {
                    symbol: 'IRR',
                    name: 'Iranian Rial',
                    symbol_native: '﷼',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'IRR',
                    name_plural: 'Iranian rials',
                },
            },
            {
                name: 'Armenia',
                isoCode: 'AM',
                phoneCode: '374',
                flag: {
                    emoji: '🇦🇲',
                    unicode: 'U+1F1E6 U+1F1F2',
                },
                currency: {
                    symbol: 'AMD',
                    name: 'Armenian Dram',
                    symbol_native: 'դր.',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'AMD',
                    name_plural: 'Armenian drams',
                },
            },
            {
                name: 'Albania',
                isoCode: 'AL',
                phoneCode: '355',
                flag: {
                    emoji: '🇦🇱',
                    unicode: 'U+1F1E6 U+1F1F1',
                },
                currency: {
                    symbol: 'ALL',
                    name: 'Albanian Lek',
                    symbol_native: 'Lek',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'ALL',
                    name_plural: 'Albanian lekë',
                },
            },
            {
                name: 'Angola',
                isoCode: 'AO',
                phoneCode: '244',
                flag: {
                    emoji: '🇦🇴',
                    unicode: 'U+1F1E6 U+1F1F4',
                },
                currency: {
                    symbol: 'Kz',
                    name: 'Angolan Kwanza',
                    symbol_native: 'Kz',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AOA',
                    name_plural: 'Angolan Kwanza',
                },
            },
            {
                name: 'Antarctica',
                isoCode: 'AQ',
                phoneCode: '00',
                flag: {
                    emoji: '🇦🇶',
                    unicode: 'U+1F1E6 U+1F1F6',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'American Samoa',
                isoCode: 'AS',
                phoneCode: '+1-684',
                flag: {
                    emoji: '🇦🇸',
                    unicode: 'U+1F1E6 U+1F1F8',
                },
                currency: {
                    symbol: '$',
                    name: 'US Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'USD',
                    name_plural: 'US dollars',
                },
            },
            {
                name: 'Argentina',
                isoCode: 'AR',
                phoneCode: '54',
                flag: {
                    emoji: '🇦🇷',
                    unicode: 'U+1F1E6 U+1F1F7',
                },
                currency: {
                    symbol: 'AR$',
                    name: 'Argentine Peso',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'ARS',
                    name_plural: 'Argentine pesos',
                },
            },
            {
                name: 'Australia',
                isoCode: 'AU',
                phoneCode: '61',
                flag: {
                    emoji: '🇦🇺',
                    unicode: 'U+1F1E6 U+1F1FA',
                },
                currency: {
                    symbol: 'AU$',
                    name: 'Australian Dollar',
                    symbol_native: '$',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AUD',
                    name_plural: 'Australian dollars',
                },
            },
            {
                name: 'Austria',
                isoCode: 'AT',
                phoneCode: '43',
                flag: {
                    emoji: '🇦🇹',
                    unicode: 'U+1F1E6 U+1F1F9',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Aruba',
                isoCode: 'AW',
                phoneCode: '297',
                flag: {
                    emoji: '🇦🇼',
                    unicode: 'U+1F1E6 U+1F1FC',
                },
                currency: {
                    symbol: 'ƒ',
                    name: 'Aruban Guilder/Florin',
                    symbol_native: 'ƒ',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AWG',
                    name_plural: 'Aruban Guilder/Florin',
                },
            },
            {
                name: 'India',
                isoCode: 'IN',
                phoneCode: '91',
                flag: {
                    emoji: '🇮🇳',
                    unicode: 'U+1F1EE U+1F1F3',
                },
                currency: {
                    symbol: 'Rs',
                    name: 'Indian Rupee',
                    symbol_native: 'টকা',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'INR',
                    name_plural: 'Indian rupees',
                },
            },
            {
                name: 'Aland Islands',
                isoCode: 'AX',
                phoneCode: '+358-18',
                flag: {
                    emoji: '🇦🇽',
                    unicode: 'U+1F1E6 U+1F1FD',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Azerbaijan',
                isoCode: 'AZ',
                phoneCode: '994',
                flag: {
                    emoji: '🇦🇿',
                    unicode: 'U+1F1E6 U+1F1FF',
                },
                currency: {
                    symbol: 'man.',
                    name: 'Azerbaijani Manat',
                    symbol_native: 'ман.',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'AZN',
                    name_plural: 'Azerbaijani manats',
                },
            },
            {
                name: 'Ireland',
                isoCode: 'IE',
                phoneCode: '353',
                flag: {
                    emoji: '🇮🇪',
                    unicode: 'U+1F1EE U+1F1EA',
                },
                currency: {
                    symbol: '€',
                    name: 'Euro',
                    symbol_native: '€',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'EUR',
                    name_plural: 'euros',
                },
            },
            {
                name: 'Indonesia',
                isoCode: 'ID',
                phoneCode: '62',
                flag: {
                    emoji: '🇮🇩',
                    unicode: 'U+1F1EE U+1F1E9',
                },
                currency: {
                    symbol: 'Rp',
                    name: 'Indonesian Rupiah',
                    symbol_native: 'Rp',
                    decimal_digits: 0,
                    rounding: 0,
                    code: 'IDR',
                    name_plural: 'Indonesian rupiahs',
                },
            },
            {
                name: 'Ukraine',
                isoCode: 'UA',
                phoneCode: '380',
                flag: {
                    emoji: '🇺🇦',
                    unicode: 'U+1F1FA U+1F1E6',
                },
                currency: {
                    symbol: '₴',
                    name: 'Ukrainian Hryvnia',
                    symbol_native: '₴',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'UAH',
                    name_plural: 'Ukrainian hryvnias',
                },
            },
            {
                name: 'Qatar',
                isoCode: 'QA',
                phoneCode: '974',
                flag: {
                    emoji: '🇶🇦',
                    unicode: 'U+1F1F6 U+1F1E6',
                },
                currency: {
                    symbol: 'QR',
                    name: 'Qatari Rial',
                    symbol_native: 'ر.ق.‏',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'QAR',
                    name_plural: 'Qatari rials',
                },
            },
            {
                name: 'Mozambique',
                isoCode: 'MZ',
                phoneCode: '258',
                flag: {
                    emoji: '🇲🇿',
                    unicode: 'U+1F1F2 U+1F1FF',
                },
                currency: {
                    symbol: 'MTn',
                    name: 'Mozambican Metical',
                    symbol_native: 'MTn',
                    decimal_digits: 2,
                    rounding: 0,
                    code: 'MZN',
                    name_plural: 'Mozambican meticals',
                },
            },
        ];
        let countries = [];
        let processed = [];
        for (const element of countryC) {
            countries.push(element.name);
        }
        countries.sort();
        for (const country of countries) {
            for (const element of countryC) {
                if (element.name === country) {
                    processed.push({
                        name: country,
                        country_code: element.isoCode,
                        country_mobile_code: element.phoneCode,
                        flag_unicode: element.flag.unicode,
                        flag_emoji: element.flag.emoji,
                        currency_name: element.currency.name,
                        currency_symbol: element.currency.symbol,
                        currency_code: element.currency.code,
                        currency_decimal: element.currency.decimal_digits,
                    });
                }
            }
        }
        await Country.updateOrCreateMany('name', processed);
    }
}
//# sourceMappingURL=country_seeder.js.map