import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'subscriber_users';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('subscriber_id').primary().notNullable();
            table.uuid('user_id').notNullable();
            table.uuid('sub_transaction_id').notNullable();
            table.string('email_address').defaultTo('');
            table.boolean('subscription_status').defaultTo(true);
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1717880712600_create_subscriber_users_table.js.map