import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_artists';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('artist_id').primary().notNullable();
            table.string('yt_artist_id').notNullable();
            table.string('artist_name').notNullable();
            table.string('artist_followers').notNullable();
            table.integer('artist_followers_count').defaultTo(0);
            table.jsonb('thumbnail').notNullable().defaultTo([]);
            table.boolean('full_detailed').defaultTo(false);
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707395712137_create_kloud_artists_table.js.map