import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'countries';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.increments('country_id');
            table.string('name');
            table.string('country_code');
            table.string('country_mobile_code');
            table.string('flag_unicode');
            table.string('flag_emoji');
            table.string('currency_name');
            table.string('currency_symbol');
            table.string('currency_code');
            table.string('currency_decimal');
            table.timestamp('created_at', { useTz: true });
            table.timestamp('updated_at', { useTz: true });
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1706441634860_create_countries_table.js.map