export const traverse = (datum, ...keys) => {
    const again = (data, key, deadEnd = false) => {
        const res = [];
        if (data instanceof Object && key in data) {
            res.push(data[key]);
            if (deadEnd)
                return res.length === 1 ? res[0] : res;
        }
        if (Array.isArray(data)) {
            res.push(...data.map((v) => again(v, key)).flat());
        }
        else if (data instanceof Object) {
            res.push(...Object.keys(data)
                .map((k) => again(data[k], key))
                .flat());
        }
        return res.length === 1 ? res[0] : res;
    };
    let value = datum;
    const lastKey = keys.at(-1);
    for (const key of keys) {
        value = again(value, key, lastKey === key);
    }
    return value;
};
export const traverseList = (data, ...keys) => {
    return [traverse(data, ...keys)].flat();
};
export const traverseString = (data, ...keys) => {
    return traverseList(data, ...keys).at(0) || '';
};
//# sourceMappingURL=traverse.js.map