import { SongDetailed, SongFull, } from '#services/YoutubeAPI/@types/types';
import checkType from '#services/YoutubeAPI/utils/check_type';
import { isAlbum, isArtist, isDuration, isTitle, isViewCount, } from '#services/YoutubeAPI/utils/filters';
import { traverseList, traverseString } from '#services/YoutubeAPI/utils/traverse';
import Parser from '#services/YoutubeAPI/parsers/parser';
export default class SongParser {
    static parse(data) {
        return checkType({
            type: 'SONG',
            videoId: traverseString(data, 'videoDetails', 'videoId'),
            name: traverseString(data, 'videoDetails', 'title'),
            artist: {
                name: traverseString(data, 'author'),
                artistId: traverseString(data, 'videoDetails', 'channelId'),
            },
            duration: +traverseString(data, 'videoDetails', 'lengthSeconds'),
            views: traverseString(data, 'viewCount'),
            thumbnails: traverseList(data, 'videoDetails', 'thumbnails'),
            formats: traverseList(data, 'streamingData', 'formats'),
            adaptiveFormats: traverseList(data, 'streamingData', 'adaptiveFormats'),
        }, SongFull);
    }
    static parseSearchResult(item) {
        const columns = traverseList(item, 'flexColumns', 'runs');
        const title = columns[0];
        const artist = columns.find(isArtist) || columns[1];
        const album = columns.find(isAlbum) ?? null;
        const duration = columns.find(isDuration);
        const totalViews = columns.find(isViewCount);
        console.log(columns);
        return checkType({
            type: 'SONG',
            videoId: traverseString(item, 'playlistItemData', 'videoId'),
            name: traverseString(title, 'text'),
            artist: {
                name: traverseString(artist, 'text'),
                artistId: traverseString(artist, 'browseId') || null,
            },
            album: album && {
                name: traverseString(album, 'text'),
                albumId: traverseString(album, 'browseId'),
            },
            duration: Parser.parseDuration(duration?.text),
            thumbnails: traverseList(item, 'thumbnails'),
            views: totalViews ? traverseString(totalViews, 'text') : undefined,
        }, SongDetailed);
    }
    static parseArtistSong(item, artistBasic) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns.find(isTitle);
        const album = columns.find(isAlbum);
        const duration = columns.find(isDuration);
        const totalViews = columns.find(isViewCount);
        return checkType({
            type: 'SONG',
            videoId: traverseString(item, 'playlistItemData', 'videoId'),
            name: traverseString(title, 'text'),
            artist: artistBasic,
            album: {
                name: traverseString(album, 'text'),
                albumId: traverseString(album, 'browseId'),
            },
            duration: duration ? Parser.parseDuration(duration.text) : null,
            thumbnails: traverseList(item, 'thumbnails'),
            views: totalViews ? traverseString(totalViews, 'text') : undefined,
        }, SongDetailed);
    }
    static parseArtistTopSong(item, artistBasic) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns.find(isTitle);
        const album = columns.find(isAlbum);
        const totalViews = columns.find(isViewCount);
        return checkType({
            type: 'SONG',
            videoId: traverseString(item, 'playlistItemData', 'videoId'),
            name: traverseString(title, 'text'),
            artist: artistBasic,
            album: {
                name: traverseString(album, 'text'),
                albumId: traverseString(album, 'browseId'),
            },
            duration: null,
            thumbnails: traverseList(item, 'thumbnails'),
            views: totalViews ? traverseString(totalViews, 'text') : undefined,
        }, SongDetailed);
    }
    static parseAlbumSong(item, artistBasic, albumBasic, thumbnails) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns.find(isTitle);
        const duration = columns.find(isDuration);
        const totalViews = columns.find(isViewCount);
        return checkType({
            type: 'SONG',
            videoId: traverseString(item, 'playlistItemData', 'videoId'),
            name: traverseString(title, 'text'),
            artist: artistBasic,
            album: albumBasic,
            duration: duration ? Parser.parseDuration(duration.text) : null,
            thumbnails,
            views: totalViews ? traverseString(totalViews, 'text') : undefined,
        }, SongDetailed);
    }
}
//# sourceMappingURL=song_parser.js.map