import { traverseList } from '#services/YoutubeAPI/utils/traverse';
import AlbumParser from '#services/YoutubeAPI/parsers/album_parser';
import ArtistParser from '#services/YoutubeAPI/parsers/artist_parser';
import PlaylistParser from '#services/YoutubeAPI/parsers/playlist_parser';
import SongParser from '#services/YoutubeAPI/parsers/song_parser';
import VideoParser from '#services/YoutubeAPI/parsers/video_parser';
export default class SearchParser {
    static parse(item) {
        const flexColumns = traverseList(item, 'flexColumns');
        const type = traverseList(flexColumns[1], 'runs', 'text').at(0);
        const parsers = {
            Song: SongParser.parseSearchResult,
            Video: VideoParser.parseSearchResult,
            Artist: ArtistParser.parseSearchResult,
            EP: AlbumParser.parseSearchResult,
            Single: AlbumParser.parseSearchResult,
            Album: AlbumParser.parseSearchResult,
            Playlist: PlaylistParser.parseSearchResult,
        };
        if (parsers[type]) {
            return parsers[type](item);
        }
        else {
            return null;
        }
    }
}
//# sourceMappingURL=search_parser.js.map