import { PlaylistDetailed, PlaylistFull, PlaylistWatch, } from '#services/YoutubeAPI/@types/types';
import checkType from '#services/YoutubeAPI/utils/check_type';
import { isArtist } from '#services/YoutubeAPI/utils/filters';
import { traverse, traverseList, traverseString } from '#services/YoutubeAPI/utils/traverse';
export default class PlaylistParser {
    static parse(data, playlistId) {
        const artist = traverse(data, 'header', 'subtitle');
        console.log(traverseList(data, 'header', 'secondSubtitle', 'text').at(0).split(' ').at(0));
        return checkType({
            type: 'PLAYLIST',
            playlistId,
            name: traverseString(data, 'header', 'title', 'text'),
            artist: {
                name: traverseString(artist, 'text'),
                artistId: traverseString(artist, 'browseId') || null,
            },
            videoCount: traverseList(data, 'header', 'secondSubtitle', 'text').at(0).split(' ').at(0) ?? null,
            totalDuration: traverseList(data, 'header', 'secondSubtitle', 'text').at(2) ?? null,
            thumbnails: traverseList(data, 'header', 'thumbnails'),
        }, PlaylistFull);
    }
    static parseSearchResult(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const title = columns[0];
        const artist = columns.find(isArtist) || columns[3];
        return checkType({
            type: 'PLAYLIST',
            playlistId: traverseString(item, 'overlay', 'playlistId'),
            name: traverseString(title, 'text'),
            artist: {
                name: traverseString(artist, 'text'),
                artistId: traverseString(artist, 'browseId') || null,
            },
            thumbnails: traverseList(item, 'thumbnails'),
        }, PlaylistDetailed);
    }
    static parseArtistFeaturedOn(item, artistBasic) {
        return checkType({
            type: 'PLAYLIST',
            playlistId: traverseString(item, 'navigationEndpoint', 'browseId'),
            name: traverseString(item, 'runs', 'text'),
            artist: artistBasic,
            thumbnails: traverseList(item, 'thumbnails'),
        }, PlaylistDetailed);
    }
    static parseWatchPlaylist(item) {
        return checkType({
            type: 'PLAYLIST',
            playlistId: traverseString(item, 'navigationEndpoint', 'playlistId'),
            name: traverseString(item, 'runs', 'text'),
            thumbnails: traverseList(item, 'thumbnails'),
        }, PlaylistWatch);
    }
}
//# sourceMappingURL=playlist_parser.js.map