import { traverse } from '#services/YoutubeAPI/utils/traverse';
export default class GenreParser {
    static parse(item) {
        const itemTitle = traverse(item, 'musicNavigationButtonRenderer', 'buttonText', 'runs', 'text');
        const itemParamsId = traverse(item, 'musicNavigationButtonRenderer', 'clickCommand', 'browseEndpoint', 'params');
        const itemColor = traverse(item, 'musicNavigationButtonRenderer', 'solid', 'leftStripeColor');
        return {
            title: itemTitle,
            paramId: itemParamsId,
            color: itemColor.toString(),
        };
    }
}
//# sourceMappingURL=genre_parser.js.map