import { traverse } from '#services/YoutubeAPI/utils/traverse';
import { PageType } from '../constants.js';
import AlbumParser from './album_parser.js';
import ArtistParser from './artist_parser.js';
import PlaylistParser from './playlist_parser.js';
import SongParser from './song_parser.js';
import VideoParser from './video_parser.js';
export default class ChartParser {
    static parseChartList(item) {
        const contents = [];
        if (item.musicTwoRowItemRenderer) {
            const itemTitle = traverse(item, 'musicTwoRowItemRenderer', 'title', 'runs', 'text');
            return [];
        }
        else if (item.musicResponsiveListItemRenderer) {
            const pageType = traverse(item, 'navigationEndpoint', 'browseEndpoint', 'browseEndpointContextSupportedConfigs', 'browseEndpointContextMusicConfig', 'pageType');
            console.log(pageType);
            const playlistId = traverse(item, 'navigationEndpoint', 'watchPlaylistEndpoint', 'playlistId');
            const videoId = traverse(item, 'navigationEndpoint', 'watchPlaylistEndpoint', 'videoId');
            switch (pageType) {
                case PageType.MUSIC_PAGE_TYPE_ARTIST:
                    contents.push(ArtistParser.parseSearchResult(item));
                    break;
                case PageType.MUSIC_PAGE_TYPE_ALBUM:
                    console.log('papap');
                    contents.push(AlbumParser.parseSearchResult(item));
                    break;
                case PageType.MUSIC_PAGE_TYPE_PLAYLIST:
                    contents.push(PlaylistParser.parseSearchResult(item));
                    break;
                default:
                    if (videoId) {
                        contents.push(VideoParser.parseVideoForChart(item));
                    }
                    else if (playlistId) {
                        contents.push(PlaylistParser.parseWatchPlaylist(item));
                    }
                    else {
                        contents.push(SongParser.parseSearchResult(item));
                    }
            }
        }
        return contents;
    }
}
//# sourceMappingURL=chart_parser.js.map