import { ArtistDetailed, ArtistFull } from '#services/YoutubeAPI/@types/types';
import checkType from '#services/YoutubeAPI/utils/check_type';
import { traverseList, traverseString } from '#services/YoutubeAPI/utils/traverse';
import AlbumParser from '#services/YoutubeAPI/parsers/album_parser';
import PlaylistParser from '#services/YoutubeAPI/parsers/playlist_parser';
import SongParser from '#services/YoutubeAPI/parsers/song_parser';
import VideoParser from '#services/YoutubeAPI/parsers/video_parser';
export default class ArtistParser {
    static parse(data, artistId) {
        const artistBasic = {
            artistId,
            name: traverseString(data, 'header', 'title', 'text'),
        };
        return checkType({
            type: 'ARTIST',
            ...artistBasic,
            follower: traverseString(data, 'subscriberCountText', 'runs', 'text').replace('subscribers', 'followers'),
            thumbnails: traverseList(data, 'header', 'thumbnails'),
            topSongs: traverseList(data, 'musicShelfRenderer', 'contents').map((item) => SongParser.parseArtistTopSong(item, artistBasic)),
            topAlbums: traverseList(data, 'musicCarouselShelfRenderer')
                ?.at(0)
                ?.contents.map((item) => AlbumParser.parseArtistTopAlbum(item, artistBasic)) ?? [],
            topSingles: traverseList(data, 'musicCarouselShelfRenderer')
                ?.at(1)
                ?.contents.map((item) => AlbumParser.parseArtistTopAlbum(item, artistBasic)) ?? [],
            topVideos: traverseList(data, 'musicCarouselShelfRenderer')
                ?.at(2)
                ?.contents.map((item) => VideoParser.parseArtistTopVideo(item, artistBasic)) ?? [],
            featuredOn: traverseList(data, 'musicCarouselShelfRenderer').length === 5
                ? traverseList(data, 'musicCarouselShelfRenderer')
                    ?.at(3)
                    ?.contents.map((item) => PlaylistParser.parseArtistFeaturedOn(item, artistBasic)) ?? []
                : [],
            similarArtists: traverseList(data, 'musicCarouselShelfRenderer').length === 5
                ? traverseList(data, 'musicCarouselShelfRenderer')
                    ?.at(4)
                    ?.contents.map((item) => this.parseSimilarArtists(item)) ?? []
                : traverseList(data, 'musicCarouselShelfRenderer')
                    ?.at(3)
                    ?.contents.map((item) => this.parseSimilarArtists(item)) ?? [],
        }, ArtistFull);
    }
    static parseSearchResult(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        console.log(columns);
        const title = columns[0];
        const subscribers = columns.filter((columnItem) => columnItem.text.includes('subscriber'))[0];
        return checkType({
            type: 'ARTIST',
            artistId: traverseString(item, 'browseId'),
            name: traverseString(title, 'text'),
            follower: subscribers
                ? traverseString(subscribers, 'text').replace('subscribers', 'followers')
                : null,
            thumbnails: traverseList(item, 'thumbnails'),
        }, ArtistDetailed);
    }
    static parseSimilarArtists(item) {
        const columns = traverseList(item, 'flexColumns', 'runs').flat();
        const subscribers = columns.filter((columnItem) => columnItem.text.includes('subscriber'))[0];
        return checkType({
            type: 'ARTIST',
            artistId: traverseString(item, 'browseId'),
            name: traverseString(item, 'title', 'runs', 'text'),
            follower: traverseString(item, 'subtitle', 'runs', 'text').replace('subscribers', 'followers') ??
                null,
            thumbnails: traverseList(item, 'thumbnails'),
        }, ArtistDetailed);
    }
}
//# sourceMappingURL=artist_parser.js.map