var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { DateTime } from 'luxon';
import { BaseModel, beforeCreate, column } from '@adonisjs/lucid/orm';
import hash from '@adonisjs/core/services/hash';
import { v4 as uuid } from 'uuid';
import { withAuthFinder } from '@adonisjs/auth';
import { compose } from '@adonisjs/core/helpers';
import { DbAccessTokensProvider } from '@adonisjs/auth/access_tokens';
const AuthFinder = withAuthFinder(() => hash.use('md5'), {
    uids: ['email'],
    passwordColumnName: 'password',
});
export default class KloudUser extends compose(BaseModel, AuthFinder) {
    static authTokens = DbAccessTokensProvider.forModel(KloudUser, {
        expiresIn: '30 days',
        prefix: 'oat_',
        table: 'kloud_user_auth_access_tokens',
        type: 'auth_token',
        tokenSecretLength: 40,
    });
    static primaryKey = 'user_id';
    static table = 'kloud_users';
    static async createUUID(user) {
        user.id = uuid();
    }
}
__decorate([
    column({ isPrimary: true, columnName: 'user_id' }),
    __metadata("design:type", String)
], KloudUser.prototype, "id", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "first_name", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "last_name", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "username", void 0);
__decorate([
    column({ columnName: 'kloud_password' }),
    __metadata("design:type", String)
], KloudUser.prototype, "password", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "avatar", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "language", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "country", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "country_code", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "address", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "city", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "state", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "zip_code", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "address2", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "gender", void 0);
__decorate([
    column(),
    __metadata("design:type", DateTime)
], KloudUser.prototype, "date_of_birth", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "phone", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "email", void 0);
__decorate([
    column(),
    __metadata("design:type", String)
], KloudUser.prototype, "auth_type", void 0);
__decorate([
    column(),
    __metadata("design:type", Number)
], KloudUser.prototype, "account_status", void 0);
__decorate([
    column.dateTime({ autoCreate: true }),
    __metadata("design:type", DateTime)
], KloudUser.prototype, "createdAt", void 0);
__decorate([
    column.dateTime({ autoCreate: true, autoUpdate: true }),
    __metadata("design:type", DateTime)
], KloudUser.prototype, "updatedAt", void 0);
__decorate([
    beforeCreate(),
    __metadata("design:type", Function),
    __metadata("design:paramtypes", [KloudUser]),
    __metadata("design:returntype", Promise)
], KloudUser, "createUUID", null);
//# sourceMappingURL=kloud_user.js.map