var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import ApiResponseService from '#services/api_response_service';
import app from '@adonisjs/core/services/app';
import fs from 'node:fs';
import { inject } from '@adonisjs/core';
let ErrorLogsController = class ErrorLogsController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async fetchAllErrorLogs() {
        try {
            const content = fs.readFileSync(app.tmpPath('log/error.log'), {
                encoding: 'utf8',
            });
            return this.apiResponseService.apiSuccessResponse(content, 'Successful');
        }
        catch (error) {
            logError(error.message, 'ErrorLogsController/fetchAllErrorLogs');
            return this.apiResponseService.apiErrorResponse(500, error.message ?? 'Server Error');
        }
    }
};
ErrorLogsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], ErrorLogsController);
export default ErrorLogsController;
//# sourceMappingURL=error_logs_controller.js.map