var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import KloudFavouriteItem from '#models/kloud_favourite_item';
import ApiResponseService from '#services/api_response_service';
import { addItemToFavouriteRequestParams } from '#validators/user_library';
import { inject } from '@adonisjs/core';
import db from '@adonisjs/lucid/services/db';
import { validate as uuidValidate } from 'uuid';
let UserFavouriteItemsController = class UserFavouriteItemsController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async fetchFavouriteItems({ auth, params }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const favouriteItemsQuery = KloudFavouriteItem.query();
            if (params.itemType === 'song' ||
                params.itemType === 'album' ||
                params.itemType === 'playlist') {
                favouriteItemsQuery.where('item_type', params.itemType);
            }
            favouriteItemsQuery.where('user_id', userToken.id);
            const favouriteItems = await favouriteItemsQuery;
            return this.apiResponseService.apiSuccessResponse(favouriteItems, 'Favourite items loaded successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserFavouriteItemsController/fetchFavouriteItems');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async addItemToFavouriteItems({ auth, request }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const payload = await addItemToFavouriteRequestParams.validate(request.all());
            await db.transaction(async (trx) => {
                try {
                    const doItemExist = await KloudFavouriteItem.query()
                        .where('item_id', payload.item_id)
                        .andWhere('user_id', userToken.id)
                        .first();
                    if (doItemExist) {
                        return this.apiResponseService.apiSuccessResponse('Item already exists in library', 'Item added to library successfully');
                    }
                    const newFavouriteItem = new KloudFavouriteItem();
                    newFavouriteItem.user_id = userToken.id;
                    newFavouriteItem.item_id = payload.item_id;
                    newFavouriteItem.item_name = payload.item_name;
                    newFavouriteItem.item_type = payload.item_type;
                    newFavouriteItem.artist = payload.artist;
                    newFavouriteItem.thumbnail = JSON.stringify(request.input('thumbnails'));
                    newFavouriteItem.useTransaction(trx);
                    await newFavouriteItem.save();
                    trx.commit();
                    return this.apiResponseService.apiSuccessResponse('', 'Item added to library successfully');
                }
                catch (error) {
                    throw Error(error);
                }
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserFavouriteItemsController/addItemToFavouriteItems');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async removeFromFavouriteItems({ auth, params }) {
        try {
            if (uuidValidate(params.favouriteId) === false) {
                return this.apiResponseService.apiErrorResponse(400, 'Favourite Id is required');
            }
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const doItemExist = await KloudFavouriteItem.query()
                .where('id', params.favouriteId)
                .andWhere('user_id', userToken.id)
                .first();
            if (!doItemExist) {
                return this.apiResponseService.apiErrorResponse(404, 'Item not found in favourite');
            }
            await doItemExist.delete();
            return this.apiResponseService.apiSuccessResponse('', 'Item removed from favourite');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserFavouriteItemsController/removeFromFavouriteItems');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
UserFavouriteItemsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], UserFavouriteItemsController);
export default UserFavouriteItemsController;
//# sourceMappingURL=user_favourite_items_controller.js.map