var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import ApiResponseService from '#services/api_response_service';
import { inject } from '@adonisjs/core';
import { googleLoginOrSignUpRequestParams } from '#validators/user_auth';
import { logError } from '#helpers/log_helpers';
import KloudUser from '#models/kloud_user';
import db from '@adonisjs/lucid/services/db';
import UserServices from '#services/UserServices/index_service';
let UserAuthsController = class UserAuthsController {
    apiResponseService;
    userService;
    constructor(apiResponseService, userService) {
        this.apiResponseService = apiResponseService;
        this.userService = userService;
    }
    async googleLoginOrSignUp({ request }) {
        try {
            const payload = await googleLoginOrSignUpRequestParams.validate(request.all());
            const doEmailExist = await KloudUser.findBy('email', payload.email);
            if (doEmailExist) {
                const token = await KloudUser.authTokens.create(doEmailExist);
                return this.apiResponseService.apiSuccessResponse({
                    user_key: doEmailExist.id,
                    username: doEmailExist.username,
                    email: doEmailExist.email,
                    auth_type: doEmailExist.auth_type,
                    name: `${doEmailExist.first_name} ${doEmailExist.last_name}`,
                    complete_profile: doEmailExist.account_status === 1,
                    token: token,
                }, 'Login Successful');
            }
            else {
                await db.transaction(async (trx) => {
                    try {
                        const kloudUser = new KloudUser();
                        kloudUser.first_name = payload.first_name;
                        kloudUser.last_name = payload.last_name;
                        kloudUser.email = payload.email;
                        kloudUser.username = payload.email.split('@')[0];
                        kloudUser.password = '';
                        kloudUser.auth_type = 'google';
                        kloudUser.account_status = 1;
                        kloudUser.avatar =
                            'https://res.cloudinary.com/dkyhablsk/image/upload/v1664847950/my-uploads/generic-user_lcheda.png';
                        kloudUser.useTransaction(trx);
                        const isCustomerSaved = await kloudUser.save();
                        trx.commit();
                        if (isCustomerSaved) {
                            const fetchEmailRow = await KloudUser.findBy('email', payload.email);
                            const token = await KloudUser.authTokens.create(fetchEmailRow);
                            await this.userService.createUserSettingEntries(kloudUser.id);
                            return this.apiResponseService.apiSuccessResponse({
                                user_key: kloudUser.id,
                                username: kloudUser.username,
                                email: kloudUser.email,
                                auth_type: kloudUser.auth_type,
                                name: `${kloudUser.first_name} ${kloudUser.last_name}`,
                                complete_profile: true,
                                token: token,
                            }, 'Registration Successful');
                        }
                    }
                    catch (error) {
                        trx.rollback();
                        logError(error.message, 'KloudaaClient/UserAuthsController/googleLoginOrSignUp-Create');
                        console.log(error.message);
                        return this.apiResponseService.apiErrorResponse(500, 'Server Error');
                    }
                });
            }
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserAuthsController/googleLoginOrSignUp');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
UserAuthsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService,
        UserServices])
], UserAuthsController);
export default UserAuthsController;
//# sourceMappingURL=user_auths_controller.js.map