var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import ApiResponseService from '#services/api_response_service';
import { inject } from '@adonisjs/core';
import { addNewAlbumRequestParams } from '#validators/user_library';
import { logError } from '#helpers/log_helpers';
import db from '@adonisjs/lucid/services/db';
import KloudAlbumLibrary from '#models/kloud_album_library';
import { validate as uuidValidate } from 'uuid';
let UserAlbumLibrariesController = class UserAlbumLibrariesController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async fetchAlbumsLibrary({ auth }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const getAlbums = await KloudAlbumLibrary.query().where('user_id', userToken.id);
            return this.apiResponseService.apiSuccessResponse(getAlbums, 'Albums loaded successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserLibrariesController/fetchAlbumsLibrary');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async addAlbumToLibrary({ auth, request }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            const payload = await addNewAlbumRequestParams.validate(request.all());
            const doAlbumExist = await KloudAlbumLibrary.query()
                .where('album_id', payload.albumId)
                .andWhere('user_id', userToken.id)
                .first();
            if (doAlbumExist) {
                return this.apiResponseService.apiSuccessResponse('Album already exists in library', 'Album added to library successfully');
            }
            await db.transaction(async (trx) => {
                try {
                    const albumLib = new KloudAlbumLibrary();
                    albumLib.user_id = userToken.id;
                    albumLib.album_id = payload.albumId;
                    albumLib.album_name = payload.name;
                    albumLib.artist = payload.artist;
                    albumLib.thumbnail = JSON.stringify(request.input('thumbnails'));
                    albumLib.useTransaction(trx);
                    await albumLib.save();
                    trx.commit();
                    return this.apiResponseService.apiSuccessResponse('', 'Album added to library successfully');
                }
                catch (error) {
                    trx.rollback();
                    logError(error.message, 'KloudaaClient/UserLibrariesController/addAlbumToLibrary');
                    console.log(error);
                    return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
                }
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserLibrariesController/addAlbumToLibrary');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async removeAlbumFromLibrary({ auth, params }) {
        try {
            const userToken = await auth.authenticateUsing(['kloudaa_user']);
            if (uuidValidate(params.albumId) === false) {
                return this.apiResponseService.apiErrorResponse(400, 'Album id is required');
            }
            const doAlbumExist = await KloudAlbumLibrary.query()
                .where('id', params.albumId)
                .andWhere('user_id', userToken.id)
                .first();
            if (!doAlbumExist) {
                return this.apiResponseService.apiErrorResponse(404, 'Album not found in library');
            }
            await doAlbumExist.delete();
            return this.apiResponseService.apiSuccessResponse('', 'Album removed from library successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/UserLibrariesController/removeAlbumFromLibrary');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
UserAlbumLibrariesController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], UserAlbumLibrariesController);
export default UserAlbumLibrariesController;
//# sourceMappingURL=user_album_libraries_controller.js.map