var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import YoutubeApiService from '#services/YoutubeAPI/index_service';
import ApiResponseService from '#services/api_response_service';
import { searchYoutubeQuery } from '#validators/youtube_query';
import { inject } from '@adonisjs/core';
let SearchesController = class SearchesController {
    apiResponseService;
    ytmusic;
    constructor(apiResponseService, ytmusic) {
        this.apiResponseService = apiResponseService;
        this.ytmusic = ytmusic;
    }
    async getSearchResults({ params, request }) {
        try {
            const data = request.all();
            const payload = await searchYoutubeQuery.validate(data);
            await this.ytmusic.initialize({
                GL: 'GB',
            });
            if (payload.filter === 'all') {
                const searchResults = await this.ytmusic.search(params.searchKeyword);
                return this.apiResponseService.apiSuccessResponse(searchResults, 'Success');
            }
            else if (payload.filter === 'album') {
                const searchResults = await this.ytmusic.searchAlbums(params.searchKeyword);
                return this.apiResponseService.apiSuccessResponse(searchResults, 'Success');
            }
            else if (payload.filter === 'artist') {
                const searchResults = await this.ytmusic.searchArtists(params.searchKeyword);
                return this.apiResponseService.apiSuccessResponse(searchResults, 'Success');
            }
            else if (payload.filter === 'song') {
                const searchResults = await this.ytmusic.searchSongs(params.searchKeyword);
                return this.apiResponseService.apiSuccessResponse(searchResults, 'Success');
            }
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/SearchesController/getSearchResults');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
};
SearchesController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService,
        YoutubeApiService])
], SearchesController);
export default SearchesController;
//# sourceMappingURL=searches_controller.js.map