import { BaseSchema } from '@adonisjs/lucid/schema';
export default class extends BaseSchema {
    tableName = 'kloud_playlist_library_items';
    async up() {
        this.schema.createTable(this.tableName, (table) => {
            table.uuid('playlist_item_id').primary().notNullable();
            table
                .uuid('playlist_id')
                .notNullable()
                .unsigned()
                .references('playlist_library_id')
                .inTable('kloud_playlist_libraries')
                .onDelete('CASCADE');
            table.string('song_id').notNullable();
            table.string('song_name').notNullable();
            table.jsonb('artist').notNullable().defaultTo({});
            table.jsonb('thumbnail').notNullable().defaultTo([]);
            table.timestamp('created_at');
            table.timestamp('updated_at');
        });
    }
    async down() {
        this.schema.dropTable(this.tableName);
    }
}
//# sourceMappingURL=1707149078145_create_kloud_playlist_library_items_table.js.map