var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import ApiResponseService from '#services/api_response_service';
import { inject } from '@adonisjs/core';
import ytdl from 'ytdl-core';
let StreamMediaContentsController = class StreamMediaContentsController {
    apiResponseService;
    constructor(apiResponseService) {
        this.apiResponseService = apiResponseService;
    }
    async streamAudioFileWithYTVideoId({ params, response }) {
        try {
            if (params.videoId === null || params.videoId === 'null') {
                return this.apiResponseService.apiErrorResponse(400, 'Video Id is required');
            }
            const videoUrl = `https://youtube.com/watch?v=${params.videoId}`;
            const videoStream = ytdl(videoUrl, {
                quality: 'highestaudio',
                requestOptions: {
                    headers: {
                        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36',
                    },
                },
            });
            response.response.writeHead(200, {
                'Content-Type': 'audio/mp3',
                'Content-Disposition': 'attachment; filename="video.mp3"',
            });
            videoStream.pipe(response.response);
            return videoStream.on('error', (err) => {
                console.error('Error reading audio stream:', err);
                response.response.writeHead(500, { 'Content-Type': 'text/plain' });
                response.response.end('500 Internal Server Error');
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/StreamMediaContentsController/streamAudioFileWithYTVideoId');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
    async streamVideoFileWithYTVideoId({ params, response }) {
        try {
            if (params.videoId === null || params.videoId === 'null') {
                return this.apiResponseService.apiErrorResponse(400, 'Video Id is required');
            }
            const videoUrl = `https://youtube.com/watch?v=${params.videoId}`;
            const videoStream = ytdl(videoUrl, {
                quality: 'highest',
                requestOptions: {
                    headers: {
                        'User-Agent': 'Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/58.0.3029.110 Safari/537.36',
                    },
                },
            });
            response.response.writeHead(200, {
                'Content-Type': 'video/mp4',
                'Content-Disposition': 'attachment; filename="klouda_video.mp4"',
            });
            videoStream.pipe(response.response);
            return videoStream.on('error', (err) => {
                console.error('Error reading video stream:', err);
                response.response.writeHead(500, { 'Content-Type': 'text/plain' });
                response.response.end('500 Internal Server Error');
            });
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/StreamMediaContentsController/streamVideoFileWithYTVideoId');
            console.log(error.message);
            return this.apiResponseService.apiErrorResponse(error.status ?? 500, error.message ?? 'Server Error');
        }
    }
};
StreamMediaContentsController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService])
], StreamMediaContentsController);
export default StreamMediaContentsController;
//# sourceMappingURL=stream_media_contents_controller.js.map