var __decorate = (this && this.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};
var __metadata = (this && this.__metadata) || function (k, v) {
    if (typeof Reflect === "object" && typeof Reflect.metadata === "function") return Reflect.metadata(k, v);
};
import { logError } from '#helpers/log_helpers';
import YoutubeApiService from '#services/YoutubeAPI/index_service';
import ApiResponseService from '#services/api_response_service';
import { inject } from '@adonisjs/core';
import redis from '@adonisjs/redis/services/main';
let GenresController = class GenresController {
    apiResponseService;
    ytmusic;
    constructor(apiResponseService, ytmusic) {
        this.apiResponseService = apiResponseService;
        this.ytmusic = ytmusic;
    }
    async getGenresList() {
        try {
            const oneWeekSeconds = 604800;
            const storedGenre = await redis.get('genres');
            if (storedGenre) {
                return this.apiResponseService.apiSuccessResponse(JSON.parse(storedGenre));
            }
            await this.ytmusic.initialize();
            const genreList = await this.ytmusic.getGenres();
            await redis.setex('genres', oneWeekSeconds, JSON.stringify(genreList));
            return this.apiResponseService.apiSuccessResponse(genreList, genreList.length ? 'Success' : 'No genres found for your country');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/SearchByGenresController/getAllGenres');
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
    async getGenresListByGenreId({ params }) {
        try {
            await this.ytmusic.initialize();
            const genreList = await this.ytmusic.getGenresItems(params.genreId);
            return this.apiResponseService.apiSuccessResponse(genreList, 'Genres fetched successfully');
        }
        catch (error) {
            logError(error.message, 'KloudaaClient/SearchByGenresController/getGenresListByGenreId');
            return this.apiResponseService.apiErrorResponse(500, 'Server Error');
        }
    }
};
GenresController = __decorate([
    inject(),
    __metadata("design:paramtypes", [ApiResponseService,
        YoutubeApiService])
], GenresController);
export default GenresController;
//# sourceMappingURL=genres_controller.js.map